/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.physical;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import lombok.NonNull;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalVertex;
import org.apache.seatunnel.engine.server.dag.physical.SubPlan;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.resourcemanager.NoEnoughResourceException;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.resource.ResourceProfile;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;

public class ResourceUtils {
    public static void applyResourceForPipeline(@NonNull ResourceManager resourceManager, @NonNull SubPlan subPlan) {
        if (resourceManager == null) {
            throw new NullPointerException("resourceManager is marked non-null but is null");
        }
        if (subPlan == null) {
            throw new NullPointerException("subPlan is marked non-null but is null");
        }
        HashMap<TaskGroupLocation, CompletableFuture> futures = new HashMap<TaskGroupLocation, CompletableFuture>();
        HashMap<TaskGroupLocation, SlotProfile> slotProfiles = new HashMap<TaskGroupLocation, SlotProfile>();
        subPlan.getCoordinatorVertexList().forEach(coordinator -> futures.put(coordinator.getTaskGroupLocation(), ResourceUtils.applyResourceForTask(resourceManager, coordinator, subPlan.getTags())));
        subPlan.getPhysicalVertexList().forEach(task -> futures.put(task.getTaskGroupLocation(), ResourceUtils.applyResourceForTask(resourceManager, task, subPlan.getTags())));
        futures.forEach((key, value) -> {
            try {
                slotProfiles.put((TaskGroupLocation)key, value == null ? null : (SlotProfile)value.join());
            }
            catch (CompletionException completionException) {
                // empty catch block
            }
        });
        subPlan.getJobMaster().setOwnedSlotProfiles(subPlan.getPipelineLocation(), slotProfiles);
        if (futures.size() != slotProfiles.size()) {
            throw new NoEnoughResourceException();
        }
    }

    public static CompletableFuture<SlotProfile> applyResourceForTask(ResourceManager resourceManager, PhysicalVertex task, Map<String, String> tags) {
        return resourceManager.applyResource(task.getTaskGroupLocation().getJobId(), new ResourceProfile(), tags);
    }
}

