/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.predicate;

import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;

public final class TernaryLogic {
    private TernaryLogic() {
    }

    public static Boolean and(Row row, ExpressionEvalContext context, Expression<?> ... operands) {
        boolean seenUnknown = false;
        for (Expression<?> operand : operands) {
            Boolean result = (Boolean)operand.eval(row, context);
            if (TernaryLogic.isFalse(result)) {
                return Boolean.FALSE;
            }
            if (!TernaryLogic.isNull(result)) continue;
            seenUnknown = true;
        }
        return seenUnknown ? null : Boolean.TRUE;
    }

    public static Boolean or(Row row, ExpressionEvalContext context, Expression<?> ... operands) {
        boolean seenUnknown = false;
        for (Expression<?> operand : operands) {
            Boolean result = (Boolean)operand.eval(row, context);
            if (TernaryLogic.isTrue(result)) {
                return Boolean.TRUE;
            }
            if (!TernaryLogic.isNull(result)) continue;
            seenUnknown = true;
        }
        return seenUnknown ? null : Boolean.FALSE;
    }

    public static Boolean not(Boolean value) {
        return value == null ? null : Boolean.valueOf(value == false);
    }

    public static boolean isNull(Object value) {
        return value == null;
    }

    public static boolean isNotNull(Object value) {
        return value != null;
    }

    public static boolean isTrue(Boolean value) {
        return value != null && value != false;
    }

    public static boolean isNotTrue(Boolean value) {
        return value == null || value == false;
    }

    public static boolean isFalse(Boolean value) {
        return value != null && value == false;
    }

    public static boolean isNotFalse(Boolean value) {
        return value == null || value != false;
    }
}

