/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.flow;

import com.hazelcast.cluster.Address;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.event.EventListener;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.MultiTableResourceManager;
import org.apache.seatunnel.api.sink.SinkCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportResourceShare;
import org.apache.seatunnel.api.sink.event.WriterCloseEvent;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableSink;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.core.checkpoint.InternalCheckpointListener;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.event.JobEventListener;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.metrics.TaskMetricsCalcContext;
import org.apache.seatunnel.engine.server.task.AbstractTask;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.context.SinkWriterContext;
import org.apache.seatunnel.engine.server.task.flow.ActionFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.OneInputFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.operation.GetTaskGroupAddressOperation;
import org.apache.seatunnel.engine.server.task.operation.checkpoint.BarrierFlowOperation;
import org.apache.seatunnel.engine.server.task.operation.sink.SinkPrepareCommitOperation;
import org.apache.seatunnel.engine.server.task.operation.sink.SinkRegisterOperation;
import org.apache.seatunnel.engine.server.task.record.Barrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkFlowLifeCycle<T, CommitInfoT extends Serializable, AggregatedCommitInfoT, StateT>
extends ActionFlowLifeCycle
implements OneInputFlowLifeCycle<Record<?>>,
InternalCheckpointListener {
    private static final Logger log = LoggerFactory.getLogger(SinkFlowLifeCycle.class);
    private final SinkAction<T, StateT, CommitInfoT, AggregatedCommitInfoT> sinkAction;
    private SinkWriter<T, CommitInfoT, StateT> writer;
    private SinkWriter.Context writerContext;
    private transient Optional<Serializer<CommitInfoT>> commitInfoSerializer;
    private transient Optional<Serializer<StateT>> writerStateSerializer;
    private final int indexID;
    private final TaskLocation taskLocation;
    private Address committerTaskAddress;
    private final TaskLocation committerTaskLocation;
    private Optional<SinkCommitter<CommitInfoT>> committer;
    private Optional<CommitInfoT> lastCommitInfo;
    private MetricsContext metricsContext;
    private TaskMetricsCalcContext taskMetricsCalcContext;
    private final boolean containAggCommitter;
    private MultiTableResourceManager resourceManager;
    private EventListener eventListener;

    public SinkFlowLifeCycle(SinkAction<T, StateT, CommitInfoT, AggregatedCommitInfoT> sinkAction, TaskLocation taskLocation, int indexID, SeaTunnelTask runningTask, TaskLocation committerTaskLocation, boolean containAggCommitter, CompletableFuture<Void> completableFuture, MetricsContext metricsContext) {
        super(sinkAction, runningTask, completableFuture);
        this.sinkAction = sinkAction;
        this.indexID = indexID;
        this.taskLocation = taskLocation;
        this.committerTaskLocation = committerTaskLocation;
        this.containAggCommitter = containAggCommitter;
        this.metricsContext = metricsContext;
        this.eventListener = new JobEventListener(taskLocation, runningTask.getExecutionContext());
        ArrayList<TablePath> sinkTables = new ArrayList();
        boolean isMulti = sinkAction.getSink() instanceof MultiTableSink;
        if (isMulti) {
            sinkTables = ((MultiTableSink)sinkAction.getSink()).getSinkTables();
        }
        this.taskMetricsCalcContext = new TaskMetricsCalcContext(metricsContext, PluginType.SINK, isMulti, sinkTables);
    }

    @Override
    public void init() throws Exception {
        this.commitInfoSerializer = this.sinkAction.getSink().getCommitInfoSerializer();
        this.writerStateSerializer = this.sinkAction.getSink().getWriterStateSerializer();
        this.committer = this.sinkAction.getSink().createCommitter();
        this.lastCommitInfo = Optional.empty();
    }

    @Override
    public void open() throws Exception {
        super.open();
        if (this.containAggCommitter) {
            this.committerTaskAddress = this.getCommitterTaskAddress();
        }
        this.registerCommitter();
    }

    private Address getCommitterTaskAddress() throws ExecutionException, InterruptedException {
        return (Address)this.runningTask.getExecutionContext().sendToMaster(new GetTaskGroupAddressOperation(this.committerTaskLocation)).get();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.writer.close();
        this.writerContext.getEventListener().onEvent(new WriterCloseEvent());
        try {
            if (this.resourceManager != null) {
                this.resourceManager.close();
            }
        }
        catch (Throwable e) {
            log.error("close resourceManager error", e);
        }
    }

    private void registerCommitter() {
        if (this.containAggCommitter) {
            this.runningTask.getExecutionContext().sendToMember(new SinkRegisterOperation(this.taskLocation, this.committerTaskLocation), this.committerTaskAddress).join();
        }
    }

    @Override
    public void received(Record<?> record) {
        block17: {
            try {
                if (record.getData() instanceof Barrier) {
                    long startTime = System.currentTimeMillis();
                    Barrier barrier = (Barrier)record.getData();
                    if (barrier.prepareClose(this.taskLocation)) {
                        this.prepareClose = true;
                    }
                    if (barrier.snapshot()) {
                        try {
                            this.lastCommitInfo = this.writer.prepareCommit();
                        }
                        catch (Exception e) {
                            this.writer.abortPrepare();
                            throw e;
                        }
                        List<StateT> states = this.writer.snapshotState(barrier.getId());
                        if (!this.writerStateSerializer.isPresent()) {
                            this.runningTask.addState(barrier, ActionStateKey.of(this.sinkAction), Collections.emptyList());
                        } else {
                            this.runningTask.addState(barrier, ActionStateKey.of(this.sinkAction), AbstractTask.serializeStates(this.writerStateSerializer.get(), states));
                        }
                        if (this.containAggCommitter) {
                            Serializable commitInfoT = null;
                            if (this.lastCommitInfo.isPresent()) {
                                commitInfoT = (Serializable)this.lastCommitInfo.get();
                            }
                            this.runningTask.getExecutionContext().sendToMember(new SinkPrepareCommitOperation(barrier, this.committerTaskLocation, this.commitInfoSerializer.isPresent() ? this.commitInfoSerializer.get().serialize(commitInfoT) : null), this.committerTaskAddress).join();
                        }
                    } else if (this.containAggCommitter) {
                        this.runningTask.getExecutionContext().sendToMember(new BarrierFlowOperation(barrier, this.committerTaskLocation), this.committerTaskAddress).join();
                    }
                    this.runningTask.ack(barrier);
                    log.debug("trigger barrier [{}] finished, cost {}ms. taskLocation [{}]", barrier.getId(), System.currentTimeMillis() - startTime, this.taskLocation);
                    break block17;
                }
                if (record.getData() instanceof SchemaChangeEvent) {
                    if (this.prepareClose.booleanValue()) {
                        return;
                    }
                    SchemaChangeEvent event = (SchemaChangeEvent)record.getData();
                    this.writer.applySchemaChange(event);
                } else {
                    if (this.prepareClose.booleanValue()) {
                        return;
                    }
                    this.writer.write(record.getData());
                    this.taskMetricsCalcContext.updateMetrics(record.getData());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        if (this.committer.isPresent() && this.lastCommitInfo.isPresent()) {
            this.committer.get().commit(Collections.singletonList((Serializable)this.lastCommitInfo.get()));
        }
    }

    @Override
    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        if (this.committer.isPresent() && this.lastCommitInfo.isPresent()) {
            this.committer.get().abort(Collections.singletonList((Serializable)this.lastCommitInfo.get()));
        }
    }

    @Override
    public void restoreState(List<ActionSubtaskState> actionStateList) throws Exception {
        List<Object> states = new ArrayList();
        if (this.writerStateSerializer.isPresent()) {
            states = actionStateList.stream().map(ActionSubtaskState::getState).flatMap(Collection::stream).filter(Objects::nonNull).map(bytes -> ExceptionUtil.sneaky(() -> this.writerStateSerializer.get().deserialize((byte[])bytes))).collect(Collectors.toList());
        }
        this.writerContext = new SinkWriterContext(this.sinkAction.getParallelism(), this.indexID, this.metricsContext, this.eventListener);
        this.writer = states.isEmpty() ? this.sinkAction.getSink().createWriter(this.writerContext) : this.sinkAction.getSink().restoreWriter(this.writerContext, states);
        if (this.writer instanceof SupportResourceShare) {
            this.resourceManager = ((SupportResourceShare)((Object)this.writer)).initMultiTableResourceManager(1, 1);
            ((SupportResourceShare)((Object)this.writer)).setMultiTableResourceManager(this.resourceManager, 0);
        }
    }
}

