/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.config;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeOption;

public class MultipleTableFakeSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<FakeConfig> fakeConfigs;

    public MultipleTableFakeSourceConfig(ReadonlyConfig fakeSourceRootConfig) {
        List tableNames;
        if (fakeSourceRootConfig.getOptional(FakeOption.TABLES_CONFIGS).isPresent()) {
            this.parseFromConfigs(fakeSourceRootConfig);
        } else {
            this.parseFromConfig(fakeSourceRootConfig);
        }
        if (this.fakeConfigs.size() > 1 && CollectionUtils.size(tableNames = this.fakeConfigs.stream().map(FakeConfig::getCatalogTable).map(catalogTable -> catalogTable.getTableId().toTablePath().toString()).collect(Collectors.toList())) != new HashSet(tableNames).size()) {
            throw new IllegalArgumentException("table name: " + tableNames + " must be unique");
        }
    }

    private void parseFromConfigs(ReadonlyConfig readonlyConfig) {
        List readonlyConfigs = ((List)readonlyConfig.getOptional(FakeOption.TABLES_CONFIGS).get()).stream().map(ReadonlyConfig::fromMap).collect(Collectors.toList());
        this.fakeConfigs = readonlyConfigs.stream().map(FakeConfig::buildWithConfig).collect(Collectors.toList());
    }

    private void parseFromConfig(ReadonlyConfig readonlyConfig) {
        FakeConfig fakeConfig = FakeConfig.buildWithConfig(readonlyConfig);
        this.fakeConfigs = Lists.newArrayList((Object[])new FakeConfig[]{fakeConfig});
    }

    public List<FakeConfig> getFakeConfigs() {
        return this.fakeConfigs;
    }
}

