/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.connector.TableTransform;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.api.table.factory.TableTransformFactoryContext;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.app.domain.request.job.DatabaseTableSchemaReq;
import org.apache.seatunnel.app.domain.request.job.PluginConfig;
import org.apache.seatunnel.app.domain.request.job.TableSchemaReq;
import org.apache.seatunnel.app.domain.request.job.transform.SQL;
import org.apache.seatunnel.app.service.IJobTaskService;
import org.apache.seatunnel.app.service.ISchemaDerivationService;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.transform.sql.SQLTransform;
import org.springframework.stereotype.Service;

@Service
public class SchemaDerivationServiceImpl
implements ISchemaDerivationService {
    @Resource
    private IJobTaskService jobTaskService;
    private static final Pattern decimalPattern = Pattern.compile("DECIMAL\\((\\d+), (\\d+)\\)");

    @Override
    public TableSchemaReq derivationSQL(long jobVersionId, String inputPluginId, SQL sql) {
        PluginConfig pluginConfig = this.jobTaskService.getSingleTask(jobVersionId, inputPluginId);
        TableTransformFactory factory = (TableTransformFactory)FactoryUtil.discoverFactory((ClassLoader)Thread.currentThread().getContextClassLoader(), TableTransformFactory.class, (String)"Sql");
        List<DatabaseTableSchemaReq> tableSchemaReqs = pluginConfig.getOutputSchema();
        if (tableSchemaReqs.isEmpty()) {
            throw new IllegalArgumentException("outputSchema is empty, please add input plugin");
        }
        DatabaseTableSchemaReq tableSchema = tableSchemaReqs.get(0);
        TableSchema.Builder builder = TableSchema.builder();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (TableField f : tableSchema.getFields()) {
            if (f.getPrimaryKey().booleanValue()) {
                primaryKeys.add(f.getName());
            }
            builder.column((Column)PhysicalColumn.of((String)f.getName(), this.stringToDataType(f.getOutputDataType()), (Integer)0, (boolean)f.getNullable(), (Object)f.getDefaultValue(), (String)f.getComment()));
        }
        builder.primaryKey(PrimaryKey.of((String)"PrimaryKeys", primaryKeys));
        CatalogTable table = CatalogTable.of((TableIdentifier)TableIdentifier.of((String)"default", (String)tableSchema.getDatabase(), (String)tableSchema.getTableName()), (TableSchema)builder.build(), Collections.emptyMap(), Collections.emptyList(), (String)tableSchema.getTableName());
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(SQLTransform.KEY_QUERY.key(), sql.getQuery());
        TableTransformFactoryContext context = new TableTransformFactoryContext(Collections.singletonList(table), ReadonlyConfig.fromMap(config), Thread.currentThread().getContextClassLoader());
        TableTransform transform = factory.createTransform(context);
        SQLTransform sqlTransform = (SQLTransform)transform.createTransform();
        CatalogTable result = sqlTransform.getProducedCatalogTable();
        ArrayList primaryKeysList = new ArrayList();
        if (result.getTableSchema().getPrimaryKey() != null) {
            primaryKeysList.addAll(result.getTableSchema().getPrimaryKey().getColumnNames());
        }
        ArrayList<TableField> fields = new ArrayList<TableField>();
        for (Column column : result.getTableSchema().getColumns()) {
            TableField field = new TableField();
            field.setName(column.getName());
            field.setComment(column.getComment());
            field.setDefaultValue(column.getDefaultValue() != null ? column.getDefaultValue().toString() : null);
            field.setNullable(Boolean.valueOf(column.isNullable()));
            field.setOutputDataType(column.getDataType().toString());
            field.setPrimaryKey(Boolean.valueOf(primaryKeysList.contains(column.getName())));
            field.setType(column.getDataType().toString());
            fields.add(field);
        }
        TableSchemaReq tableSchemaRes = new TableSchemaReq();
        tableSchemaRes.setFields(fields);
        tableSchemaRes.setTableName(tableSchema.getTableName());
        return tableSchemaRes;
    }

    private SeaTunnelDataType<?> stringToDataType(String dataTypeStr) {
        switch (dataTypeStr = dataTypeStr.toUpperCase()) {
            case "STRING": {
                return BasicType.STRING_TYPE;
            }
            case "BOOLEAN": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "TINYINT": {
                return BasicType.BYTE_TYPE;
            }
            case "SMALLINT": {
                return BasicType.SHORT_TYPE;
            }
            case "INT": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "NULL": {
                return BasicType.VOID_TYPE;
            }
            case "BYTES": {
                return ArrayType.BYTE_ARRAY_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "TIMESTAMP": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "DECIMAL": {
                return new DecimalType(38, 18);
            }
            case "ARRAY": 
            case "MAP": 
            case "ROW": 
            case "MULTIPLE_ROW": {
                return BasicType.STRING_TYPE;
            }
        }
        Matcher matcher = decimalPattern.matcher(dataTypeStr);
        if (matcher.matches()) {
            int precision = Integer.parseInt(matcher.group(1));
            int scale = Integer.parseInt(matcher.group(2));
            return new DecimalType(precision, scale);
        }
        return BasicType.STRING_TYPE;
    }
}

