/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions.geohash;

import java.io.Serializable;
import org.apache.spark.sql.sedona_sql.expressions.geohash.InvalidGeoHashException;
import org.apache.spark.sql.sedona_sql.expressions.geohash.LatLon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.mutable.Seq;
import scala.collection.mutable.Seq$;
import scala.math.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class GeoHashDecoder$ {
    public static final GeoHashDecoder$ MODULE$ = new GeoHashDecoder$();
    private static final scala.collection.immutable.Seq<Object> bits = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{16, 8, 4, 2, 1}));
    private static final String base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
    private static final GeometryFactory geometryFactory = new GeometryFactory();

    private scala.collection.immutable.Seq<Object> bits() {
        return bits;
    }

    private String base32() {
        return base32;
    }

    public GeometryFactory geometryFactory() {
        return geometryFactory;
    }

    public Geometry decode(String geohash, Option<Object> precision) {
        return this.decodeGeoHashBBox(geohash, precision).getBbox().toPolygon();
    }

    public Option<Object> decode$default$2() {
        return None$.MODULE$;
    }

    private LatLon decodeGeoHashBBox(String geohash, Option<Object> precision) {
        int n;
        LatLon latLon = new LatLon((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{-180.0, 180.0}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{-90.0, 90.0}))));
        String geoHashLowered = geohash.toLowerCase();
        int geoHashLength = geohash.length();
        Option<Object> option = precision;
        if (option instanceof Some) {
            Some some = (Some)option;
            int value = BoxesRunTime.unboxToInt((Object)some.value());
            if (value < 0) {
                throw new InvalidGeoHashException("Precision can not be negative");
            }
            n = package$.MODULE$.min(geoHashLength, value);
        } else if (None$.MODULE$.equals(option)) {
            n = geoHashLength;
        } else {
            throw new MatchError(option);
        }
        int targetPrecision = n;
        BooleanRef isEven = BooleanRef.create((boolean)true);
        scala.package$.MODULE$.Range().apply(0, targetPrecision).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(geoHashLowered), i);
            byte cd = (byte)MODULE$.base32().indexOf(c);
            if (cd == -1) {
                throw new InvalidGeoHashException(new StringBuilder(36).append("Invalid character '").append(c).append("' found at index ").append(i).toString());
            }
            scala.package$.MODULE$.Range().apply(0, 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                int index;
                byte mask = (byte)BoxesRunTime.unboxToInt((Object)MODULE$.bits().apply(j));
                int n = index = (byte)(mask & cd) == 0 ? 1 : 0;
                if (isEven$1.elem) {
                    latLon.lons().update(index, (Object)BoxesRunTime.boxToDouble((double)((BoxesRunTime.unboxToDouble((Object)latLon.lons().head()) + BoxesRunTime.unboxToDouble((Object)latLon.lons().apply(1))) / (double)2)));
                } else {
                    latLon.lats().update(index, (Object)BoxesRunTime.boxToDouble((double)((BoxesRunTime.unboxToDouble((Object)latLon.lats().head()) + BoxesRunTime.unboxToDouble((Object)latLon.lats().apply(1))) / (double)2)));
                }
                isEven$1.elem = !isEven$1.elem;
            });
        });
        return latLon;
    }

    private Option<Object> decodeGeoHashBBox$default$2() {
        return None$.MODULE$;
    }

    private GeoHashDecoder$() {
    }
}

