/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser;

import it.geosolutions.jaiext.jiffle.parser.CompilerMessage;
import it.geosolutions.jaiext.jiffle.parser.Errors;
import it.geosolutions.jaiext.jiffle.parser.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class Messages {
    private List<Message> messages = new ArrayList<Message>();
    private boolean error;
    private boolean warning;

    public void error(Token tok, String msg) {
        this.messages.add(new CompilerMessage(Message.Level.ERROR, tok, msg));
        this.error = true;
    }

    public void error(Token tok, Errors error) {
        this.messages.add(new CompilerMessage(Message.Level.ERROR, tok, error.toString()));
    }

    public void error(int line, int charPos, String msg) {
        this.messages.add(new CompilerMessage(Message.Level.ERROR, line, charPos, msg));
        this.error = true;
    }

    public void warning(Token tok, String msg) {
        this.messages.add(new CompilerMessage(Message.Level.WARNING, tok, msg));
        this.warning = true;
    }

    public void warning(int line, int charPos, String msg) {
        this.messages.add(new CompilerMessage(Message.Level.WARNING, line, charPos, msg));
        this.warning = true;
    }

    public List<Message> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isWarning() {
        return this.warning;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Message msg : this.messages) {
            sb.append(msg.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

