/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.showcase;

import java.awt.Color;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sedona.common.enums.FileDataSplitter;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.formatMapper.EarthdataHDFPointMapper;
import org.apache.sedona.core.spatialOperator.JoinQuery;
import org.apache.sedona.core.spatialRDD.PointRDD;
import org.apache.sedona.core.spatialRDD.PolygonRDD;
import org.apache.sedona.core.spatialRDD.RectangleRDD;
import org.apache.sedona.viz.core.ImageGenerator;
import org.apache.sedona.viz.core.ImageSerializableWrapper;
import org.apache.sedona.viz.core.RasterOverlayOperator;
import org.apache.sedona.viz.extension.visualizationEffect.ChoroplethMap;
import org.apache.sedona.viz.extension.visualizationEffect.HeatMap;
import org.apache.sedona.viz.extension.visualizationEffect.ScatterPlot;
import org.apache.sedona.viz.showcase.ScalaExample$delayedInit$body;
import org.apache.sedona.viz.utils.ColorizeOption;
import org.apache.sedona.viz.utils.ImageType;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;
import scala.App;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;

public final class ScalaExample$
implements App {
    public static ScalaExample$ MODULE$;
    private SparkConf sparkConf;
    private SparkContext sparkContext;
    private Properties prop;
    private String resourcePath;
    private String demoOutputPath;
    private String scatterPlotOutputPath;
    private String heatMapOutputPath;
    private String choroplethMapOutputPath;
    private String parallelFilterRenderStitchOutputPath;
    private String earthdataScatterPlotOutputPath;
    private String PointInputLocation;
    private int PointOffset;
    private FileDataSplitter PointSplitter;
    private int PointNumPartitions;
    private String RectangleInputLocation;
    private int RectangleOffset;
    private FileDataSplitter RectangleSplitter;
    private int RectangleNumPartitions;
    private String PolygonInputLocation;
    private int PolygonOffset;
    private FileDataSplitter PolygonSplitter;
    private int PolygonNumPartitions;
    private String LineStringInputLocation;
    private int LineStringOffset;
    private FileDataSplitter LineStringSplitter;
    private int LineStringNumPartitions;
    private Envelope USMainLandBoundary;
    private String earthdataInputLocation;
    private int earthdataNumPartitions;
    private int HDFIncrement;
    private int HDFOffset;
    private String HDFRootGroupName;
    private String HDFDataVariableName;
    private String[] HDFDataVariableList;
    private boolean HDFswitchXY;
    private String urlPrefix;
    private FileInputStream ConfFile;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new ScalaExample$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public Properties prop() {
        return this.prop;
    }

    public String resourcePath() {
        return this.resourcePath;
    }

    public String demoOutputPath() {
        return this.demoOutputPath;
    }

    public String scatterPlotOutputPath() {
        return this.scatterPlotOutputPath;
    }

    public String heatMapOutputPath() {
        return this.heatMapOutputPath;
    }

    public String choroplethMapOutputPath() {
        return this.choroplethMapOutputPath;
    }

    public String parallelFilterRenderStitchOutputPath() {
        return this.parallelFilterRenderStitchOutputPath;
    }

    public String earthdataScatterPlotOutputPath() {
        return this.earthdataScatterPlotOutputPath;
    }

    public String PointInputLocation() {
        return this.PointInputLocation;
    }

    public int PointOffset() {
        return this.PointOffset;
    }

    public FileDataSplitter PointSplitter() {
        return this.PointSplitter;
    }

    public int PointNumPartitions() {
        return this.PointNumPartitions;
    }

    public String RectangleInputLocation() {
        return this.RectangleInputLocation;
    }

    public int RectangleOffset() {
        return this.RectangleOffset;
    }

    public FileDataSplitter RectangleSplitter() {
        return this.RectangleSplitter;
    }

    public int RectangleNumPartitions() {
        return this.RectangleNumPartitions;
    }

    public String PolygonInputLocation() {
        return this.PolygonInputLocation;
    }

    public int PolygonOffset() {
        return this.PolygonOffset;
    }

    public FileDataSplitter PolygonSplitter() {
        return this.PolygonSplitter;
    }

    public int PolygonNumPartitions() {
        return this.PolygonNumPartitions;
    }

    public String LineStringInputLocation() {
        return this.LineStringInputLocation;
    }

    public int LineStringOffset() {
        return this.LineStringOffset;
    }

    public FileDataSplitter LineStringSplitter() {
        return this.LineStringSplitter;
    }

    public int LineStringNumPartitions() {
        return this.LineStringNumPartitions;
    }

    public Envelope USMainLandBoundary() {
        return this.USMainLandBoundary;
    }

    public String earthdataInputLocation() {
        return this.earthdataInputLocation;
    }

    public int earthdataNumPartitions() {
        return this.earthdataNumPartitions;
    }

    public int HDFIncrement() {
        return this.HDFIncrement;
    }

    public int HDFOffset() {
        return this.HDFOffset;
    }

    public String HDFRootGroupName() {
        return this.HDFRootGroupName;
    }

    public String HDFDataVariableName() {
        return this.HDFDataVariableName;
    }

    public String[] HDFDataVariableList() {
        return this.HDFDataVariableList;
    }

    public boolean HDFswitchXY() {
        return this.HDFswitchXY;
    }

    public String urlPrefix() {
        return this.urlPrefix;
    }

    public FileInputStream ConfFile() {
        return this.ConfFile;
    }

    public void ConfFile_$eq(FileInputStream x$1) {
        this.ConfFile = x$1;
    }

    public boolean buildScatterPlot(String outputPath) {
        PolygonRDD spatialRDD = new PolygonRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.PolygonInputLocation(), this.PolygonSplitter(), false, Predef$.MODULE$.int2Integer(this.PolygonNumPartitions()));
        ScatterPlot visualizationOperator = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        visualizationOperator = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false, -1, -1, false, true);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), spatialRDD);
        imageGenerator = new ImageGenerator();
        imageGenerator.SaveVectorImageAsLocalFile(visualizationOperator.vectorImage, outputPath, ImageType.SVG);
        visualizationOperator = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false, -1, -1, true, true);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), spatialRDD);
        imageGenerator = new ImageGenerator();
        imageGenerator.SaveVectorImageAsLocalFile((JavaPairRDD<Integer, String>)visualizationOperator.distributedVectorImage, new StringBuilder(19).append("file://").append(outputPath).append("-distributed").toString(), ImageType.SVG);
        return true;
    }

    public boolean buildHeatMap(String outputPath) {
        RectangleRDD spatialRDD = new RectangleRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.RectangleInputLocation(), this.RectangleSplitter(), false, Predef$.MODULE$.int2Integer(this.RectangleNumPartitions()));
        HeatMap visualizationOperator = new HeatMap(1000, 600, this.USMainLandBoundary(), false, 2);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public boolean buildChoroplethMap(String outputPath) {
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.PointInputLocation(), Predef$.MODULE$.int2Integer(this.PointOffset()), this.PointSplitter(), false, Predef$.MODULE$.int2Integer(this.PointNumPartitions()));
        PolygonRDD queryRDD = new PolygonRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.PolygonInputLocation(), this.PolygonSplitter(), false, Predef$.MODULE$.int2Integer(this.PolygonNumPartitions()));
        spatialRDD.spatialPartitioning(GridType.KDBTREE);
        queryRDD.spatialPartitioning(spatialRDD.getPartitioner());
        spatialRDD.buildIndex(IndexType.RTREE, true);
        JavaPairRDD<Polygon, Long> joinResult = JoinQuery.SpatialJoinQueryCountByKey(spatialRDD, queryRDD, true, false);
        ChoroplethMap visualizationOperator = new ChoroplethMap(1000, 600, this.USMainLandBoundary(), false);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.RED, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), joinResult);
        ScatterPlot frontImage = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false);
        frontImage.CustomizeColor(0, 0, 0, 255, Color.GREEN, true);
        frontImage.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), queryRDD);
        RasterOverlayOperator overlayOperator = new RasterOverlayOperator(visualizationOperator.rasterImage);
        overlayOperator.JoinImage(frontImage.rasterImage);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(overlayOperator.backRasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public boolean parallelFilterRenderNoStitch(String outputPath) {
        RectangleRDD spatialRDD = new RectangleRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.RectangleInputLocation(), this.RectangleSplitter(), false, Predef$.MODULE$.int2Integer(this.RectangleNumPartitions()));
        HeatMap visualizationOperator = new HeatMap(1000, 600, this.USMainLandBoundary(), false, 2, 4, 4, true, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile((JavaPairRDD<Integer, ImageSerializableWrapper>)visualizationOperator.distributedRasterImage, outputPath, ImageType.PNG, 0, 4, 4);
        return true;
    }

    public boolean parallelFilterRenderStitch(String outputPath) {
        RectangleRDD spatialRDD = new RectangleRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.RectangleInputLocation(), this.RectangleSplitter(), false, Predef$.MODULE$.int2Integer(this.RectangleNumPartitions()));
        HeatMap visualizationOperator = new HeatMap(1000, 600, this.USMainLandBoundary(), false, 2, 4, 4, true, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public boolean earthdataVisualization(String outputPath) {
        EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(this.HDFIncrement(), this.HDFOffset(), this.HDFRootGroupName(), this.HDFDataVariableList(), this.HDFDataVariableName(), this.HDFswitchXY(), this.urlPrefix());
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.earthdataInputLocation(), Predef$.MODULE$.int2Integer(this.earthdataNumPartitions()), earthdataHDFPoint);
        ScatterPlot visualizationOperator = new ScatterPlot(1000, 600, spatialRDD.boundaryEnvelope, ColorizeOption.EARTHOBSERVATION, false, false);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.BLUE, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public final void delayedEndpoint$org$apache$sedona$viz$showcase$ScalaExample$1() {
        this.sparkConf = new SparkConf().setAppName("SedonaVizDemo").setMaster("local[4]");
        this.sparkContext = new SparkContext(this.sparkConf());
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        this.prop = new Properties();
        this.resourcePath = "/../spark/common/src/test/resources/";
        this.demoOutputPath = "target/demo";
        this.scatterPlotOutputPath = new StringBuilder(13).append(System.getProperty("user.dir")).append("/").append(this.demoOutputPath()).append("/scatterplot").toString();
        this.prop().load(this.ConfFile());
        this.heatMapOutputPath = new StringBuilder(9).append(System.getProperty("user.dir")).append("/").append(this.demoOutputPath()).append("/heatmap").toString();
        this.choroplethMapOutputPath = new StringBuilder(15).append(System.getProperty("user.dir")).append("/").append(this.demoOutputPath()).append("/choroplethmap").toString();
        this.parallelFilterRenderStitchOutputPath = new StringBuilder(35).append(System.getProperty("user.dir")).append("/").append(this.demoOutputPath()).append("/parallelfilterrenderstitchheatmap").toString();
        this.earthdataScatterPlotOutputPath = new StringBuilder(22).append(System.getProperty("user.dir")).append("/").append(this.demoOutputPath()).append("/earthdatascatterplot").toString();
        this.PointInputLocation = new StringBuilder(8).append("file://").append(System.getProperty("user.dir")).append("/").append(this.resourcePath()).append(this.prop().getProperty("inputLocation")).toString();
        this.PointOffset = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("offset"))).toInt();
        this.PointSplitter = FileDataSplitter.getFileDataSplitter(this.prop().getProperty("splitter"));
        this.PointNumPartitions = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions"))).toInt();
        this.RectangleInputLocation = new StringBuilder(8).append("file://").append(System.getProperty("user.dir")).append("/").append(this.resourcePath()).append(this.prop().getProperty("inputLocation")).toString();
        this.ConfFile_$eq(new FileInputStream(new StringBuilder(28).append(this.resourcePath()).append("babylon.rectangle.properties").toString()));
        this.prop().load(this.ConfFile());
        this.RectangleOffset = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("offset"))).toInt();
        this.RectangleSplitter = FileDataSplitter.getFileDataSplitter(this.prop().getProperty("splitter"));
        this.RectangleNumPartitions = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions"))).toInt();
        this.PolygonInputLocation = new StringBuilder(8).append("file://").append(System.getProperty("user.dir")).append("/").append(this.resourcePath()).append(this.prop().getProperty("inputLocation")).toString();
        this.ConfFile_$eq(new FileInputStream(new StringBuilder(26).append(this.resourcePath()).append("babylon.polygon.properties").toString()));
        this.prop().load(this.ConfFile());
        this.PolygonOffset = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("offset"))).toInt();
        this.PolygonSplitter = FileDataSplitter.getFileDataSplitter(this.prop().getProperty("splitter"));
        this.PolygonNumPartitions = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions"))).toInt();
        this.LineStringInputLocation = new StringBuilder(8).append("file://").append(System.getProperty("user.dir")).append("/").append(this.resourcePath()).append(this.prop().getProperty("inputLocation")).toString();
        this.ConfFile_$eq(new FileInputStream(new StringBuilder(29).append(this.resourcePath()).append("babylon.linestring.properties").toString()));
        this.prop().load(this.ConfFile());
        this.LineStringOffset = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("offset"))).toInt();
        this.LineStringSplitter = FileDataSplitter.getFileDataSplitter(this.prop().getProperty("splitter"));
        this.LineStringNumPartitions = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions"))).toInt();
        this.USMainLandBoundary = new Envelope(-126.79018, -64.630926, 24.863836, 50.0);
        this.earthdataInputLocation = new StringBuilder(51).append(System.getProperty("user.dir")).append("/../spark/common/src/test/resources/modis/modis.csv").toString();
        this.earthdataNumPartitions = 5;
        this.HDFIncrement = 5;
        this.HDFOffset = 2;
        this.HDFRootGroupName = "MOD_Swath_LST";
        this.HDFDataVariableName = "LST";
        this.HDFDataVariableList = (String[])((Object[])new String[]{"LST", "QC", "Error_LST", "Emis_31", "Emis_32"});
        this.HDFswitchXY = true;
        this.urlPrefix = new StringBuilder(42).append(System.getProperty("user.dir")).append("/../spark/common/src/test/resources/modis/").toString();
        this.ConfFile = new FileInputStream(new StringBuilder(24).append(this.resourcePath()).append("babylon.point.properties").toString());
        if (this.buildScatterPlot(this.scatterPlotOutputPath()) && this.buildHeatMap(this.heatMapOutputPath()) && this.buildChoroplethMap(this.choroplethMapOutputPath()) && this.parallelFilterRenderStitch(new StringBuilder(9).append(this.parallelFilterRenderStitchOutputPath()).append("-stitched").toString()) && this.parallelFilterRenderNoStitch(this.parallelFilterRenderStitchOutputPath()) && this.earthdataVisualization(this.earthdataScatterPlotOutputPath())) {
            System.out.println("All 5 Demos have passed.");
        } else {
            System.out.println("Demos failed.");
        }
    }

    private ScalaExample$() {
        MODULE$ = this;
        App.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new ScalaExample$delayedInit$body(this));
    }
}

