/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.snowflake.snowsql.udtfs;

import java.util.stream.Stream;
import org.apache.sedona.snowflake.snowsql.GeometrySerde;
import org.apache.sedona.snowflake.snowsql.annotations.UDTFAnnotations;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;

@UDTFAnnotations.TabularFunc(name="ST_Envelope_Aggr", argNames={"geom"})
public class ST_Envelope_Aggr {
    public static final GeometryFactory geometryFactory = new GeometryFactory();
    Envelope buffer = null;

    public static Class getOutputClass() {
        return OutputRow.class;
    }

    public Stream<OutputRow> process(byte[] geom) throws ParseException {
        Geometry geometry = GeometrySerde.deserialize(geom);
        if (this.buffer == null) {
            this.buffer = geometry.getEnvelopeInternal();
        } else {
            this.buffer.expandToInclude(geometry.getEnvelopeInternal());
        }
        return Stream.empty();
    }

    public Stream<OutputRow> endPartition() {
        Polygon poly = geometryFactory.createPolygon(geometryFactory.createLinearRing(new Coordinate[]{new Coordinate(this.buffer.getMinX(), this.buffer.getMinY()), new Coordinate(this.buffer.getMinX(), this.buffer.getMaxY()), new Coordinate(this.buffer.getMaxX(), this.buffer.getMaxY()), new Coordinate(this.buffer.getMaxX(), this.buffer.getMinY()), new Coordinate(this.buffer.getMinX(), this.buffer.getMinY())}));
        return Stream.of(new OutputRow(GeometrySerde.serialize(poly)));
    }

    public static class OutputRow {
        public byte[] envelope;

        public OutputRow(byte[] envelopePolygon) {
            this.envelope = envelopePolygon;
        }
    }
}

