/*
 * Decompiled with CFR 0.152.
 */
package net.sf.geographiclib;

import net.sf.geographiclib.Accumulator;
import net.sf.geographiclib.GeoMath;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicData;
import net.sf.geographiclib.Pair;
import net.sf.geographiclib.PolygonResult;

public class PolygonArea {
    private Geodesic _earth;
    private double _area0;
    private boolean _polyline;
    private int _mask;
    private int _num;
    private int _crossings;
    private Accumulator _areasum;
    private Accumulator _perimetersum;
    private double _lat0;
    private double _lon0;
    private double _lat1;
    private double _lon1;

    private static int transit(double lon1, double lon2) {
        lon1 = GeoMath.AngNormalize(lon1);
        lon2 = GeoMath.AngNormalize(lon2);
        Pair p = new Pair();
        GeoMath.AngDiff(p, lon1, lon2);
        double lon12 = p.first;
        int cross = lon1 <= 0.0 && lon2 > 0.0 && lon12 > 0.0 ? 1 : (lon2 <= 0.0 && lon1 > 0.0 && lon12 < 0.0 ? -1 : 0);
        return cross;
    }

    private static int transitdirect(double lon1, double lon2) {
        return ((lon2 %= 720.0) <= 0.0 && lon2 > -360.0 || lon2 > 360.0 ? 1 : 0) - ((lon1 %= 720.0) <= 0.0 && lon1 > -360.0 || lon1 > 360.0 ? 1 : 0);
    }

    private static double AreaReduceA(Accumulator area, double area0, int crossings, boolean reverse, boolean sign) {
        area.Remainder(area0);
        if ((crossings & 1) != 0) {
            area.Add((double)(area.Sum() < 0.0 ? 1 : -1) * area0 / 2.0);
        }
        if (!reverse) {
            area.Negate();
        }
        if (sign) {
            if (area.Sum() > area0 / 2.0) {
                area.Add(-area0);
            } else if (area.Sum() <= -area0 / 2.0) {
                area.Add(area0);
            }
        } else if (area.Sum() >= area0) {
            area.Add(-area0);
        } else if (area.Sum() < 0.0) {
            area.Add(area0);
        }
        return 0.0 + area.Sum();
    }

    private static double AreaReduceB(double area, double area0, int crossings, boolean reverse, boolean sign) {
        area = GeoMath.remainder(area, area0);
        if ((crossings & 1) != 0) {
            area += (double)(area < 0.0 ? 1 : -1) * area0 / 2.0;
        }
        if (!reverse) {
            area *= -1.0;
        }
        if (sign) {
            if (area > area0 / 2.0) {
                area -= area0;
            } else if (area <= -area0 / 2.0) {
                area += area0;
            }
        } else if (area >= area0) {
            area -= area0;
        } else if (area < 0.0) {
            area += area0;
        }
        return 0.0 + area;
    }

    public PolygonArea(Geodesic earth, boolean polyline) {
        this._earth = earth;
        this._area0 = this._earth.EllipsoidArea();
        this._polyline = polyline;
        this._mask = 0x589 | (this._polyline ? 0 : 49168);
        this._perimetersum = new Accumulator(0.0);
        if (!this._polyline) {
            this._areasum = new Accumulator(0.0);
        }
        this.Clear();
    }

    public void Clear() {
        this._num = 0;
        this._crossings = 0;
        this._perimetersum.Set(0.0);
        if (!this._polyline) {
            this._areasum.Set(0.0);
        }
        this._lon1 = Double.NaN;
        this._lat1 = Double.NaN;
        this._lon0 = Double.NaN;
        this._lat0 = Double.NaN;
    }

    public void AddPoint(double lat, double lon) {
        lon = GeoMath.AngNormalize(lon);
        if (this._num == 0) {
            this._lat0 = this._lat1 = lat;
            this._lon0 = this._lon1 = lon;
        } else {
            GeodesicData g2 = this._earth.Inverse(this._lat1, this._lon1, lat, lon, this._mask);
            this._perimetersum.Add(g2.s12);
            if (!this._polyline) {
                this._areasum.Add(g2.S12);
                this._crossings += PolygonArea.transit(this._lon1, lon);
            }
            this._lat1 = lat;
            this._lon1 = lon;
        }
        ++this._num;
    }

    public void AddEdge(double azi, double s2) {
        if (this._num > 0) {
            GeodesicData g2 = this._earth.Direct(this._lat1, this._lon1, azi, s2, this._mask);
            this._perimetersum.Add(g2.s12);
            if (!this._polyline) {
                this._areasum.Add(g2.S12);
                this._crossings += PolygonArea.transitdirect(this._lon1, g2.lon2);
            }
            this._lat1 = g2.lat2;
            this._lon1 = g2.lon2;
            ++this._num;
        }
    }

    public PolygonResult Compute() {
        return this.Compute(false, true);
    }

    public PolygonResult Compute(boolean reverse, boolean sign) {
        if (this._num < 2) {
            return new PolygonResult(this._num, 0.0, this._polyline ? Double.NaN : 0.0);
        }
        if (this._polyline) {
            return new PolygonResult(this._num, this._perimetersum.Sum(), Double.NaN);
        }
        GeodesicData g2 = this._earth.Inverse(this._lat1, this._lon1, this._lat0, this._lon0, this._mask);
        Accumulator tempsum = new Accumulator(this._areasum);
        tempsum.Add(g2.S12);
        return new PolygonResult(this._num, this._perimetersum.Sum(g2.s12), PolygonArea.AreaReduceA(tempsum, this._area0, this._crossings + PolygonArea.transit(this._lon1, this._lon0), reverse, sign));
    }

    public PolygonResult TestPoint(double lat, double lon, boolean reverse, boolean sign) {
        if (this._num == 0) {
            return new PolygonResult(1, 0.0, this._polyline ? Double.NaN : 0.0);
        }
        double perimeter = this._perimetersum.Sum();
        double tempsum = this._polyline ? 0.0 : this._areasum.Sum();
        int crossings = this._crossings;
        int num = this._num + 1;
        for (int i = 0; i < (this._polyline ? 1 : 2); ++i) {
            GeodesicData g2 = this._earth.Inverse(i == 0 ? this._lat1 : lat, i == 0 ? this._lon1 : lon, i != 0 ? this._lat0 : lat, i != 0 ? this._lon0 : lon, this._mask);
            perimeter += g2.s12;
            if (this._polyline) continue;
            tempsum += g2.S12;
            crossings += PolygonArea.transit(i == 0 ? this._lon1 : lon, i != 0 ? this._lon0 : lon);
        }
        if (this._polyline) {
            return new PolygonResult(num, perimeter, Double.NaN);
        }
        return new PolygonResult(num, perimeter, PolygonArea.AreaReduceB(tempsum, this._area0, crossings, reverse, sign));
    }

    public PolygonResult TestEdge(double azi, double s2, boolean reverse, boolean sign) {
        if (this._num == 0) {
            return new PolygonResult(0, Double.NaN, Double.NaN);
        }
        int num = this._num + 1;
        double perimeter = this._perimetersum.Sum() + s2;
        if (this._polyline) {
            return new PolygonResult(num, perimeter, Double.NaN);
        }
        double tempsum = this._areasum.Sum();
        int crossings = this._crossings;
        GeodesicData g2 = this._earth.Direct(this._lat1, this._lon1, azi, false, s2, this._mask);
        tempsum += g2.S12;
        crossings += PolygonArea.transitdirect(this._lon1, g2.lon2);
        g2 = this._earth.Inverse(g2.lat2, g2.lon2, this._lat0, this._lon0, this._mask);
        return new PolygonResult(num, perimeter += g2.s12, PolygonArea.AreaReduceB(tempsum += g2.S12, this._area0, crossings += PolygonArea.transit(g2.lon2, this._lon0), reverse, sign));
    }

    public double EquatorialRadius() {
        return this._earth.EquatorialRadius();
    }

    public double Flattening() {
        return this._earth.Flattening();
    }

    public Pair CurrentPoint() {
        return new Pair(this._lat1, this._lon1);
    }

    @Deprecated
    public double MajorRadius() {
        return this.EquatorialRadius();
    }
}

