/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf.extractors;

import java.util.HashMap;
import org.apache.sedona.sql.datasources.osmpbf.build.Osmformat;
import org.apache.sedona.sql.datasources.osmpbf.features.TagsResolver;
import org.apache.sedona.sql.datasources.osmpbf.model.Way;

public class WaysExtractor {
    Osmformat.PrimitiveGroup primitiveGroup;
    Osmformat.StringTable stringTable;

    public WaysExtractor(Osmformat.PrimitiveGroup primitiveGroup, Osmformat.StringTable stringTable) {
        this.primitiveGroup = primitiveGroup;
        this.stringTable = stringTable;
    }

    public Way extract(int idx) {
        Osmformat.Way way = this.primitiveGroup.getWays(idx);
        return this.parse(way);
    }

    private Way parse(Osmformat.Way way) {
        long[] refs = new long[way.getRefsCount()];
        long firstRef = 0L;
        if (way.getRefsCount() != 0) {
            for (int i = 0; i < way.getRefsCount(); ++i) {
                refs[i] = firstRef += way.getRefs(i);
            }
        }
        HashMap<String, String> tags = TagsResolver.resolveTags(way.getKeysCount(), way::getKeys, way::getVals, this.stringTable);
        return new Way(way.getId(), tags, refs);
    }
}

