/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import com.google.common.eventbus.EventBus;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.SpectatorUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.registry.GlobalRegistry;
import org.apache.servicecomb.metrics.core.meter.os.OsMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsMetersInitializer
implements MetricsInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsMetersInitializer.class);
    private OsMeter osMeter;

    public void init(GlobalRegistry globalRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        if (!SystemUtils.IS_OS_LINUX) {
            LOGGER.info("only support linux os to collect cpu and net info");
            return;
        }
        Registry registry = globalRegistry.getDefaultRegistry();
        this.osMeter = new OsMeter(registry);
        SpectatorUtils.registerMeter((Registry)registry, (Meter)this.osMeter);
    }

    public OsMeter getOsMeter() {
        return this.osMeter;
    }
}

