/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.bean;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.protobuf.internal.bean.BeanDescriptor;

public class BeanDescriptorManager {
    private final SerializationConfig serializationConfig;
    private final Map<Type, BeanDescriptor> beanDescriptors = new ConcurrentHashMapEx();

    public BeanDescriptorManager(SerializationConfig serializationConfig) {
        this.serializationConfig = serializationConfig;
    }

    public BeanDescriptor getOrCreateBeanDescriptor(Type type) {
        return this.beanDescriptors.computeIfAbsent(type, this::createBeanDescriptor);
    }

    protected BeanDescriptor createBeanDescriptor(Type type) {
        return this.createBeanDescriptor(TypeFactory.defaultInstance().constructType(type));
    }

    protected BeanDescriptor createBeanDescriptor(JavaType javaType) {
        BeanDescriptor beanDescriptor = new BeanDescriptor();
        beanDescriptor.init(this.serializationConfig, javaType);
        return beanDescriptor;
    }
}

