/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.solution.basic.integration;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.provider.LocalOpenAPIRegistry;
import org.apache.servicecomb.provider.rest.common.RestSchema;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.solution.basic.integration.ManagementEndpoint;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RestSchema(schemaId="scb-management", schemaInterface=ManagementEndpoint.class)
public class ManagementEndpointImpl
implements ManagementEndpoint {
    private RegistrationManager registrationManager;
    private LocalOpenAPIRegistry localOpenAPIRegistry;

    @Autowired
    public void setRegistrationManager(RegistrationManager registrationManager) {
        this.registrationManager = registrationManager;
    }

    @Autowired
    public void setLocalOpenAPIRegistry(LocalOpenAPIRegistry localOpenAPIRegistry) {
        this.localOpenAPIRegistry = localOpenAPIRegistry;
    }

    @Override
    public boolean health(String instanceId, String registryName) {
        if (StringUtils.isEmpty((CharSequence)instanceId) || StringUtils.isEmpty((CharSequence)registryName)) {
            return false;
        }
        String mySelf = this.registrationManager.getInstanceId(registryName);
        if (StringUtils.isEmpty((CharSequence)mySelf)) {
            return false;
        }
        return mySelf.equals(instanceId);
    }

    @Override
    public Map<String, String> schemaContents() {
        Map apis = this.localOpenAPIRegistry.loadOpenAPI();
        HashMap<String, String> result = new HashMap<String, String>(apis.size());
        apis.forEach((k, v) -> result.put((String)k, SwaggerUtils.swaggerToString((OpenAPI)v)));
        return result;
    }
}

