/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.util;

import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LocalVariableVisitor
extends MethodVisitor {
    private String[] parameterNames;
    private final int[] lvtSlotIndex;
    private final Type[] args;

    public LocalVariableVisitor(int api, String desc, boolean isStatic, String[] parameterNames) {
        super(api);
        this.parameterNames = parameterNames;
        this.args = Type.getArgumentTypes((String)desc);
        this.lvtSlotIndex = this.computeLvtSlotIndices(isStatic, this.args);
    }

    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        for (int i = 0; i < this.lvtSlotIndex.length; ++i) {
            if (this.lvtSlotIndex[i] != index) continue;
            this.parameterNames[i] = name;
        }
        super.visitLocalVariable(name, descriptor, signature, start, end, index);
    }

    int[] computeLvtSlotIndices(boolean isStatic, Type[] paramTypes) {
        int[] lvtIndex = new int[paramTypes.length];
        int nextIndex = isStatic ? 0 : 1;
        for (int i = 0; i < paramTypes.length; ++i) {
            lvtIndex[i] = nextIndex++;
            if (!this.isWideType(paramTypes[i])) continue;
            nextIndex += 2;
        }
        return lvtIndex;
    }

    private boolean isWideType(Type aType) {
        return aType == Type.LONG_TYPE || aType == Type.DOUBLE_TYPE;
    }
}

