/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.internal;

import org.apache.commons.logging.Log;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.osgi.framework.BundleContext;

public class JclLogger
implements Log {
    public static final String JCL_FQCN = JclLogger.class.getName();
    private PaxLogger m_delegate;

    public JclLogger(PaxLogger delegate) {
        this.m_delegate = delegate;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.m_delegate.isFatalEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    @Override
    public void trace(Object message) {
        if (this.m_delegate.isTraceEnabled() && message != null) {
            this.m_delegate.trace(message.toString(), null);
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (this.m_delegate.isTraceEnabled()) {
            if (message != null) {
                this.m_delegate.trace(message.toString(), t);
            } else {
                this.m_delegate.trace(null, t);
            }
        }
    }

    @Override
    public void debug(Object message) {
        if (this.m_delegate.isDebugEnabled() && message != null) {
            this.m_delegate.debug(message.toString(), null);
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.m_delegate.isDebugEnabled()) {
            if (message != null) {
                this.m_delegate.debug(message.toString(), t);
            } else {
                this.m_delegate.debug(null, t);
            }
        }
    }

    @Override
    public void info(Object message) {
        if (this.m_delegate.isInfoEnabled() && message != null) {
            this.m_delegate.inform(message.toString(), null);
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (this.m_delegate.isInfoEnabled()) {
            if (message != null) {
                this.m_delegate.inform(message.toString(), t);
            } else {
                this.m_delegate.inform(null, t);
            }
        }
    }

    @Override
    public void warn(Object message) {
        if (this.m_delegate.isWarnEnabled() && message != null) {
            this.m_delegate.warn(message.toString(), null);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.m_delegate.isWarnEnabled()) {
            if (message != null) {
                this.m_delegate.warn(message.toString(), t);
            } else {
                this.m_delegate.warn(null, t);
            }
        }
    }

    @Override
    public void error(Object message) {
        if (this.m_delegate.isErrorEnabled() && message != null) {
            this.m_delegate.error(message.toString(), null);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.m_delegate.isErrorEnabled()) {
            if (message != null) {
                this.m_delegate.error(message.toString(), t);
            } else {
                this.m_delegate.error(null, t);
            }
        }
    }

    @Override
    public void fatal(Object message) {
        if (this.m_delegate.isFatalEnabled() && message != null) {
            this.m_delegate.fatal(message.toString(), null);
        }
    }

    @Override
    public void fatal(Object message, Throwable t) {
        if (this.m_delegate.isFatalEnabled()) {
            if (message != null) {
                this.m_delegate.fatal(message.toString(), t);
            } else {
                this.m_delegate.fatal(null, t);
            }
        }
    }

    public int getLogLevel() {
        return this.m_delegate.getLogLevel();
    }

    public void setBundleContext(BundleContext context) {
    }

    public void setPaxLoggingManager(PaxLoggingManager paxLoggingManager, String name) {
        this.m_delegate = paxLoggingManager.getLogger(name, JCL_FQCN);
    }
}

