/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.node.metadata;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class TableMetaDataNode {
    private static final String ROOT_NODE = "metadata";
    private static final String SCHEMAS_NODE = "schemas";
    private static final String TABLES_NODE = "tables";
    private static final String ACTIVE_VERSION = "active_version";
    private static final String VERSIONS = "versions";
    private static final String TABLES_PATTERN = "/([\\w\\-]+)/schemas/([\\w\\-]+)/tables";
    private static final String ACTIVE_VERSION_SUFFIX = "/([\\w\\-]+)/active_version";
    private static final String TABLE_SUFFIX = "/([\\w\\-]+)$";

    public static String getMetaDataTablesNode(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", TableMetaDataNode.getMetaDataNode(), databaseName, SCHEMAS_NODE, schemaName, TABLES_NODE);
    }

    public static String getTableActiveVersionNode(String databaseName, String schemaName, String tableName) {
        return String.join((CharSequence)"/", TableMetaDataNode.getMetaDataNode(), databaseName, SCHEMAS_NODE, schemaName, TABLES_NODE, tableName, ACTIVE_VERSION);
    }

    public static String getTableVersionsNode(String databaseName, String schemaName, String tableName) {
        return String.join((CharSequence)"/", TableMetaDataNode.getMetaDataNode(), databaseName, SCHEMAS_NODE, schemaName, TABLES_NODE, tableName, VERSIONS);
    }

    public static String getTableVersionNode(String databaseName, String schemaName, String tableName, String version) {
        return String.join((CharSequence)"/", TableMetaDataNode.getTableVersionsNode(databaseName, schemaName, tableName), version);
    }

    public static String getTableNode(String databaseName, String schemaName, String tableName) {
        return String.join((CharSequence)"/", TableMetaDataNode.getMetaDataNode(), databaseName, SCHEMAS_NODE, schemaName, TABLES_NODE, tableName);
    }

    public static Optional<String> getTableNameByActiveVersionNode(String path) {
        Pattern pattern = Pattern.compile(TableMetaDataNode.getMetaDataNode() + TABLES_PATTERN + ACTIVE_VERSION_SUFFIX, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static Optional<String> getTableName(String path) {
        Pattern pattern = Pattern.compile(TableMetaDataNode.getMetaDataNode() + TABLES_PATTERN + TABLE_SUFFIX, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static boolean isTableActiveVersionNode(String path) {
        return Pattern.compile(TableMetaDataNode.getMetaDataNode() + TABLES_PATTERN + ACTIVE_VERSION_SUFFIX, 2).matcher(path).find();
    }

    public static boolean isTableNode(String path) {
        return Pattern.compile(TableMetaDataNode.getMetaDataNode() + TABLES_PATTERN + TABLE_SUFFIX, 2).matcher(path).find();
    }

    private static String getMetaDataNode() {
        return String.join((CharSequence)"/", "", ROOT_NODE);
    }

    @Generated
    private TableMetaDataNode() {
    }
}

