/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.table;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.subquery.SubqueryTableContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.subquery.engine.SubqueryTableContextEngine;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class TablesContext {
    private final Collection<TableSegment> tables = new LinkedList<TableSegment>();
    private final Collection<SimpleTableSegment> simpleTables = new LinkedList<SimpleTableSegment>();
    private final Collection<String> tableNames = new CaseInsensitiveSet();
    private final Collection<String> schemaNames = new CaseInsensitiveSet();
    private final Collection<String> databaseNames = new CaseInsensitiveSet();
    private final Map<String, Collection<SubqueryTableContext>> subqueryTables = new HashMap<String, Collection<SubqueryTableContext>>();
    private final Map<String, IdentifierValue> tableNameAliasMap = new HashMap<String, IdentifierValue>();

    public TablesContext(SimpleTableSegment table, DatabaseType databaseType, String currentDatabaseName) {
        this(null == table ? Collections.emptyList() : Collections.singletonList(table), databaseType, currentDatabaseName);
    }

    public TablesContext(Collection<SimpleTableSegment> tables, DatabaseType databaseType, String currentDatabaseName) {
        this(tables, Collections.emptyMap(), databaseType, currentDatabaseName);
    }

    public TablesContext(Collection<? extends TableSegment> tables, Map<Integer, SelectStatementContext> subqueryContexts, DatabaseType databaseType, String currentDatabaseName) {
        if (tables.isEmpty()) {
            return;
        }
        this.tables.addAll(tables);
        for (TableSegment tableSegment : tables) {
            if (tableSegment instanceof SimpleTableSegment && !"DUAL".equalsIgnoreCase(((SimpleTableSegment)tableSegment).getTableName().getIdentifier().getValue())) {
                SimpleTableSegment simpleTableSegment = (SimpleTableSegment)tableSegment;
                this.simpleTables.add(simpleTableSegment);
                this.tableNames.add(simpleTableSegment.getTableName().getIdentifier().getValue());
                simpleTableSegment.getOwner().ifPresent(optional -> this.schemaNames.add(optional.getIdentifier().getValue()));
                this.databaseNames.add(this.findDatabaseName(simpleTableSegment, databaseType).orElse(currentDatabaseName));
                this.tableNameAliasMap.put(simpleTableSegment.getTableName().getIdentifier().getValue().toLowerCase(), tableSegment.getAlias().orElse(simpleTableSegment.getTableName().getIdentifier()));
            }
            if (!(tableSegment instanceof SubqueryTableSegment)) continue;
            this.subqueryTables.putAll(this.createSubqueryTables(subqueryContexts, (SubqueryTableSegment)tableSegment));
        }
    }

    private Optional<String> findDatabaseName(SimpleTableSegment tableSegment, DatabaseType databaseType) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        Optional<String> owner = dialectDatabaseMetaData.getDefaultSchema().isPresent() ? tableSegment.getOwner().flatMap(OwnerSegment::getOwner) : tableSegment.getOwner();
        return owner.map(optional -> optional.getIdentifier().getValue());
    }

    private Map<String, Collection<SubqueryTableContext>> createSubqueryTables(Map<Integer, SelectStatementContext> subqueryContexts, SubqueryTableSegment subqueryTable) {
        SelectStatementContext subqueryContext = subqueryContexts.get(subqueryTable.getSubquery().getStartIndex());
        Map<String, SubqueryTableContext> subqueryTableContexts = new SubqueryTableContextEngine().createSubqueryTableContexts(subqueryContext, subqueryTable.getAliasName().orElse(null));
        HashMap<String, Collection<SubqueryTableContext>> result = new HashMap<String, Collection<SubqueryTableContext>>(subqueryTableContexts.size(), 1.0f);
        for (SubqueryTableContext each : subqueryTableContexts.values()) {
            if (null == each.getAliasName()) continue;
            result.computeIfAbsent(each.getAliasName(), unused -> new LinkedList()).add(each);
        }
        return result;
    }

    public Map<String, String> findTableNames(Collection<ColumnSegment> columns, ShardingSphereSchema schema) {
        if (1 == this.simpleTables.size()) {
            return this.findTableNameFromSingleTable(columns);
        }
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        Map<String, Collection<String>> ownerColumnNames = this.getOwnerColumnNames(columns);
        result.putAll(this.findTableNameFromSQL(ownerColumnNames));
        Collection<String> noOwnerColumnNames = this.getNoOwnerColumnNames(columns);
        result.putAll(this.findTableNameFromMetaData(noOwnerColumnNames, schema));
        result.putAll(this.findTableNameFromSubquery(columns, (Map<String, String>)result));
        return result;
    }

    private Map<String, String> findTableNameFromSubquery(Collection<ColumnSegment> columns, Map<String, String> ownerTableNames) {
        if (ownerTableNames.size() == columns.size() || this.subqueryTables.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(columns.size(), 1.0f);
        for (ColumnSegment each : columns) {
            if (ownerTableNames.containsKey(each.getExpression())) continue;
            String owner = each.getOwner().map(optional -> optional.getIdentifier().getValue()).orElse("");
            Collection subqueryTableContexts = this.subqueryTables.getOrDefault(owner, Collections.emptyList());
            for (SubqueryTableContext subqueryTableContext : subqueryTableContexts) {
                if (!subqueryTableContext.getColumnNames().contains(each.getIdentifier().getValue())) continue;
                result.put(each.getExpression(), subqueryTableContext.getTableName());
            }
        }
        return result;
    }

    private Map<String, String> findTableNameFromSingleTable(Collection<ColumnSegment> columns) {
        String tableName = this.simpleTables.iterator().next().getTableName().getIdentifier().getValue();
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (ColumnSegment each : columns) {
            result.putIfAbsent(each.getExpression(), tableName);
        }
        return result;
    }

    private Map<String, Collection<String>> getOwnerColumnNames(Collection<ColumnSegment> columns) {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (ColumnSegment each : columns) {
            if (!each.getOwner().isPresent()) continue;
            result.computeIfAbsent(((OwnerSegment)each.getOwner().get()).getIdentifier().getValue(), unused -> new LinkedList()).add(each.getExpression());
        }
        return result;
    }

    private Map<String, String> findTableNameFromSQL(Map<String, Collection<String>> ownerColumnNames) {
        if (ownerColumnNames.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.simpleTables.size(), 1.0f);
        for (SimpleTableSegment each : this.simpleTables) {
            Optional alias;
            String tableName = each.getTableName().getIdentifier().getValue();
            if (ownerColumnNames.containsKey(tableName)) {
                ownerColumnNames.get(tableName).forEach(column -> result.put((String)column, tableName));
            }
            if (!(alias = each.getAliasName()).isPresent() || !ownerColumnNames.containsKey(alias.get())) continue;
            ownerColumnNames.get(alias.get()).forEach(column -> result.put((String)column, tableName));
        }
        return result;
    }

    private Map<String, String> findTableNameFromMetaData(Collection<String> noOwnerColumnNames, ShardingSphereSchema schema) {
        if (noOwnerColumnNames.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(noOwnerColumnNames.size(), 1.0f);
        for (SimpleTableSegment each : this.simpleTables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            for (String columnName : schema.getAllColumnNames(tableName)) {
                if (!noOwnerColumnNames.contains(columnName)) continue;
                result.put(columnName, tableName);
            }
        }
        return result;
    }

    private Collection<String> getNoOwnerColumnNames(Collection<ColumnSegment> columns) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ColumnSegment each : columns) {
            if (each.getOwner().isPresent()) continue;
            result.add(each.getIdentifier().getValue());
        }
        return result;
    }

    public Optional<String> getDatabaseName() {
        Preconditions.checkState((this.databaseNames.size() <= 1 ? 1 : 0) != 0, (Object)"Can not support multiple different database.");
        return this.databaseNames.isEmpty() ? Optional.empty() : Optional.of(this.databaseNames.iterator().next());
    }

    public Optional<String> getSchemaName() {
        return this.schemaNames.isEmpty() ? Optional.empty() : Optional.of(this.schemaNames.iterator().next());
    }

    @Generated
    public Collection<SimpleTableSegment> getSimpleTables() {
        return this.simpleTables;
    }

    @Generated
    public Collection<String> getTableNames() {
        return this.tableNames;
    }

    @Generated
    public Collection<String> getSchemaNames() {
        return this.schemaNames;
    }

    @Generated
    public Collection<String> getDatabaseNames() {
        return this.databaseNames;
    }

    @Generated
    public Map<String, IdentifierValue> getTableNameAliasMap() {
        return this.tableNameAliasMap;
    }

    @Generated
    public String toString() {
        return "TablesContext(tables=" + this.tables + ", simpleTables=" + this.getSimpleTables() + ", tableNames=" + this.getTableNames() + ", schemaNames=" + this.getSchemaNames() + ", databaseNames=" + this.getDatabaseNames() + ", subqueryTables=" + this.subqueryTables + ", tableNameAliasMap=" + this.getTableNameAliasMap() + ")";
    }
}

