/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.projection.type;

import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;

public final class ShorthandProjectionSegmentBinder {
    public static ShorthandProjectionSegment bind(ShorthandProjectionSegment segment, TableSegment boundTableSegment, Map<String, TableSegmentBinderContext> tableBinderContexts) {
        ShorthandProjectionSegment result = ShorthandProjectionSegmentBinder.copy(segment);
        if (segment.getOwner().isPresent()) {
            ShorthandProjectionSegmentBinder.expandVisibleColumns(ShorthandProjectionSegmentBinder.getProjectionSegmentsByTableAliasOrName(tableBinderContexts, ((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue()), result);
        } else {
            ShorthandProjectionSegmentBinder.expandNoOwnerProjections(boundTableSegment, tableBinderContexts, result);
        }
        return result;
    }

    private static ShorthandProjectionSegment copy(ShorthandProjectionSegment segment) {
        ShorthandProjectionSegment result = new ShorthandProjectionSegment(segment.getStartIndex(), segment.getStopIndex());
        segment.getOwner().ifPresent(arg_0 -> ((ShorthandProjectionSegment)result).setOwner(arg_0));
        segment.getAliasSegment().ifPresent(arg_0 -> ((ShorthandProjectionSegment)result).setAlias(arg_0));
        return result;
    }

    private static Collection<ProjectionSegment> getProjectionSegmentsByTableAliasOrName(Map<String, TableSegmentBinderContext> tableBinderContexts, String tableAliasOrName) {
        ShardingSpherePreconditions.checkContainsKey(tableBinderContexts, (Object)tableAliasOrName.toLowerCase(), () -> new IllegalStateException(String.format("Can not find table binder context by table alias or name %s.", tableAliasOrName)));
        return tableBinderContexts.get(tableAliasOrName.toLowerCase()).getProjectionSegments();
    }

    private static void expandVisibleColumns(Collection<ProjectionSegment> projectionSegments, ShorthandProjectionSegment segment) {
        for (ProjectionSegment each : projectionSegments) {
            if (!each.isVisible()) continue;
            segment.getActualProjectionSegments().add(each);
        }
    }

    private static void expandNoOwnerProjections(TableSegment boundTableSegment, Map<String, TableSegmentBinderContext> tableBinderContexts, ShorthandProjectionSegment segment) {
        if (boundTableSegment instanceof SimpleTableSegment) {
            String tableAliasOrName = boundTableSegment.getAliasName().orElseGet(() -> ((SimpleTableSegment)boundTableSegment).getTableName().getIdentifier().getValue());
            ShorthandProjectionSegmentBinder.expandVisibleColumns(ShorthandProjectionSegmentBinder.getProjectionSegmentsByTableAliasOrName(tableBinderContexts, tableAliasOrName), segment);
        } else if (boundTableSegment instanceof JoinTableSegment) {
            ShorthandProjectionSegmentBinder.expandVisibleColumns(((JoinTableSegment)boundTableSegment).getDerivedJoinTableProjectionSegments(), segment);
        } else if (boundTableSegment instanceof SubqueryTableSegment) {
            ShorthandProjectionSegmentBinder.expandVisibleColumns(ShorthandProjectionSegmentBinder.getProjectionSegmentsByTableAliasOrName(tableBinderContexts, boundTableSegment.getAliasName().orElse("")), segment);
        }
    }

    @Generated
    private ShorthandProjectionSegmentBinder() {
    }
}

