/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine;

import java.sql.Connection;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.callback.add.StatementAddCallback;
import org.apache.shardingsphere.driver.executor.callback.execute.StatementExecuteUpdateCallback;
import org.apache.shardingsphere.driver.executor.callback.replay.StatementReplayCallback;
import org.apache.shardingsphere.driver.executor.engine.pushdown.jdbc.DriverJDBCPushDownExecuteUpdateExecutor;
import org.apache.shardingsphere.driver.executor.engine.pushdown.raw.DriverRawPushDownExecuteUpdateExecutor;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.raw.RawExecutionRuleAttribute;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class DriverExecuteUpdateExecutor {
    private final ShardingSphereConnection connection;
    private final ShardingSphereMetaData metaData;
    private final DriverJDBCPushDownExecuteUpdateExecutor jdbcPushDownExecutor;
    private final DriverRawPushDownExecuteUpdateExecutor rawPushDownExecutor;

    public DriverExecuteUpdateExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, JDBCExecutor jdbcExecutor, RawExecutor rawExecutor) {
        this.connection = connection;
        this.metaData = metaData;
        this.jdbcPushDownExecutor = new DriverJDBCPushDownExecuteUpdateExecutor(connection, metaData, jdbcExecutor);
        this.rawPushDownExecutor = new DriverRawPushDownExecuteUpdateExecutor(connection, metaData, rawExecutor);
    }

    public int executeUpdate(ShardingSphereDatabase database, QueryContext queryContext, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, StatementExecuteUpdateCallback updateCallback, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        ExecutionContext executionContext = new KernelProcessor().generateExecutionContext(queryContext, this.metaData.getGlobalRuleMetaData(), this.metaData.getProps(), this.connection.getDatabaseConnectionManager().getConnectionContext());
        return database.getRuleMetaData().getAttributes(RawExecutionRuleAttribute.class).isEmpty() ? this.jdbcPushDownExecutor.executeUpdate(database, executionContext, prepareEngine, updateCallback, addCallback, replayCallback) : this.rawPushDownExecutor.executeUpdate(database, executionContext);
    }

    @Generated
    public DriverExecuteUpdateExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, DriverJDBCPushDownExecuteUpdateExecutor jdbcPushDownExecutor, DriverRawPushDownExecuteUpdateExecutor rawPushDownExecutor) {
        this.connection = connection;
        this.metaData = metaData;
        this.jdbcPushDownExecutor = jdbcPushDownExecutor;
        this.rawPushDownExecutor = rawPushDownExecutor;
    }
}

