/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.config.yaml.config;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.datasource.yaml.config.YamlPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.config.yaml.config.YamlPipelineJobConfiguration;

public final class YamlMigrationJobConfiguration
implements YamlPipelineJobConfiguration {
    private String jobId;
    private String targetDatabaseName;
    private String sourceDatabaseType;
    private String targetDatabaseType;
    private Map<String, YamlPipelineDataSourceConfiguration> sources;
    private YamlPipelineDataSourceConfiguration target;
    private List<String> targetTableNames;
    private Map<String, String> targetTableSchemaMap;
    private String tablesFirstDataNodes;
    private List<String> jobShardingDataNodes;
    private int concurrency = 3;
    private int retryTimes = 3;

    public String getDatabaseName() {
        return this.targetDatabaseName;
    }

    public void setSources(Map<String, YamlPipelineDataSourceConfiguration> sources) {
        sources.values().forEach(this::checkParameters);
        this.sources = sources;
    }

    public void setTarget(YamlPipelineDataSourceConfiguration target) {
        this.checkParameters(target);
        this.target = target;
    }

    private void checkParameters(YamlPipelineDataSourceConfiguration yamlConfig) {
        Preconditions.checkNotNull((Object)yamlConfig);
        Preconditions.checkNotNull((Object)yamlConfig.getType());
        Preconditions.checkNotNull((Object)yamlConfig.getParameter());
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public String getTargetDatabaseName() {
        return this.targetDatabaseName;
    }

    @Generated
    public String getSourceDatabaseType() {
        return this.sourceDatabaseType;
    }

    @Generated
    public String getTargetDatabaseType() {
        return this.targetDatabaseType;
    }

    @Generated
    public Map<String, YamlPipelineDataSourceConfiguration> getSources() {
        return this.sources;
    }

    @Generated
    public YamlPipelineDataSourceConfiguration getTarget() {
        return this.target;
    }

    @Generated
    public List<String> getTargetTableNames() {
        return this.targetTableNames;
    }

    @Generated
    public Map<String, String> getTargetTableSchemaMap() {
        return this.targetTableSchemaMap;
    }

    @Generated
    public String getTablesFirstDataNodes() {
        return this.tablesFirstDataNodes;
    }

    @Generated
    public List<String> getJobShardingDataNodes() {
        return this.jobShardingDataNodes;
    }

    @Generated
    public int getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public int getRetryTimes() {
        return this.retryTimes;
    }

    @Generated
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Generated
    public void setTargetDatabaseName(String targetDatabaseName) {
        this.targetDatabaseName = targetDatabaseName;
    }

    @Generated
    public void setSourceDatabaseType(String sourceDatabaseType) {
        this.sourceDatabaseType = sourceDatabaseType;
    }

    @Generated
    public void setTargetDatabaseType(String targetDatabaseType) {
        this.targetDatabaseType = targetDatabaseType;
    }

    @Generated
    public void setTargetTableNames(List<String> targetTableNames) {
        this.targetTableNames = targetTableNames;
    }

    @Generated
    public void setTargetTableSchemaMap(Map<String, String> targetTableSchemaMap) {
        this.targetTableSchemaMap = targetTableSchemaMap;
    }

    @Generated
    public void setTablesFirstDataNodes(String tablesFirstDataNodes) {
        this.tablesFirstDataNodes = tablesFirstDataNodes;
    }

    @Generated
    public void setJobShardingDataNodes(List<String> jobShardingDataNodes) {
        this.jobShardingDataNodes = jobShardingDataNodes;
    }

    @Generated
    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    @Generated
    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }
}

