/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.context.aware.CursorAware;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CloseStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CursorStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.CursorAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.SQLExceptionTransformEngine;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.EmptyStorageUnitException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.EmptyRuleException;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.metadata.JDBCQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.util.SystemSchemaUtils;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.session.connection.cursor.CursorConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefreshEngine;
import org.apache.shardingsphere.proxy.backend.connector.AdvancedProxySQLExecutor;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.connector.ProxySQLExecutor;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback.ProxyJDBCExecutorCallback;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback.ProxyJDBCExecutorCallbackFactory;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.transaction.BackendTransactionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.data.DatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeaderBuilderEngine;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.transaction.TransactionStatus;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtils;
import org.apache.shardingsphere.sharding.merge.common.IteratorStreamMergedResult;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLInsertStatement;
import org.apache.shardingsphere.sqlfederation.executor.context.SQLFederationContext;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.implicit.ImplicitTransactionCallback;

public final class DatabaseConnector
implements DatabaseBackendHandler {
    private final String driverType;
    private final QueryContext queryContext;
    private final ProxyDatabaseConnectionManager databaseConnectionManager;
    private final ContextManager contextManager;
    private final ShardingSphereDatabase database;
    private final boolean containsDerivedProjections;
    private final ProxySQLExecutor proxySQLExecutor;
    private final Collection<Statement> cachedStatements = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<ResultSet> cachedResultSets = Collections.newSetFromMap(new ConcurrentHashMap());
    private List<QueryHeader> queryHeaders;
    private MergedResult mergedResult;

    public DatabaseConnector(String driverType, QueryContext queryContext, ProxyDatabaseConnectionManager databaseConnectionManager) {
        this.driverType = driverType;
        this.queryContext = queryContext;
        this.databaseConnectionManager = databaseConnectionManager;
        this.contextManager = ProxyContext.getInstance().getContextManager();
        this.database = queryContext.getUsedDatabase();
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        this.checkBackendReady(sqlStatementContext);
        boolean bl = this.containsDerivedProjections = sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).containsDerivedProjections();
        if (sqlStatementContext instanceof CursorAvailable) {
            this.prepareCursorStatementContext((CursorAvailable)sqlStatementContext);
        }
        this.proxySQLExecutor = new ProxySQLExecutor(driverType, databaseConnectionManager, this, queryContext);
    }

    private void checkBackendReady(SQLStatementContext sqlStatementContext) {
        boolean isSystemSchema = SystemSchemaUtils.containsSystemSchema((DatabaseType)sqlStatementContext.getDatabaseType(), sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaNames() : Collections.emptyList(), (ShardingSphereDatabase)this.database);
        ShardingSpherePreconditions.checkState((isSystemSchema || this.database.containsDataSource() ? 1 : 0) != 0, () -> new EmptyStorageUnitException(this.database.getName()));
        ShardingSpherePreconditions.checkState((isSystemSchema || this.database.isComplete() ? 1 : 0) != 0, () -> new EmptyRuleException(this.database.getName()));
    }

    private void prepareCursorStatementContext(CursorAvailable statementContext) {
        if (statementContext.getCursorName().isPresent()) {
            this.prepareCursorStatementContext(statementContext, ((CursorNameSegment)statementContext.getCursorName().get()).getIdentifier().getValue().toLowerCase());
        }
        if (statementContext instanceof CloseStatementContext && ((CloseStatementContext)statementContext).getSqlStatement().isCloseAll()) {
            this.databaseConnectionManager.getConnectionSession().getConnectionContext().clearCursorContext();
        }
    }

    private void prepareCursorStatementContext(CursorAvailable statementContext, String cursorName) {
        CursorConnectionContext cursorContext = this.databaseConnectionManager.getConnectionSession().getConnectionContext().getCursorContext();
        if (statementContext instanceof CursorStatementContext) {
            cursorContext.getCursorStatementContexts().put(cursorName, (CursorStatementContext)statementContext);
        }
        if (statementContext instanceof CursorAware) {
            ShardingSpherePreconditions.checkContainsKey((Map)cursorContext.getCursorStatementContexts(), (Object)cursorName, () -> new IllegalArgumentException(String.format("Cursor %s does not exist.", cursorName)));
            ((CursorAware)statementContext).setCursorStatementContext((CursorStatementContext)cursorContext.getCursorStatementContexts().get(cursorName));
        }
        if (statementContext instanceof CloseStatementContext) {
            cursorContext.removeCursor(cursorName);
        }
    }

    public void add(Statement statement) {
        this.cachedStatements.add(statement);
    }

    public void add(ResultSet resultSet) {
        this.cachedResultSets.add(resultSet);
    }

    @Override
    public ResponseHeader execute() throws SQLException {
        if (this.proxySQLExecutor.getSqlFederationEngine().decide(this.queryContext, this.contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData())) {
            return this.processExecuteFederation(this.doExecuteFederation());
        }
        MetaDataRefreshEngine metaDataRefreshEngine = this.getMetaDataRefreshEngine();
        if (this.proxySQLExecutor.getSqlFederationEngine().enabled() && metaDataRefreshEngine.isFederation(this.queryContext.getSqlStatementContext())) {
            metaDataRefreshEngine.refresh(this.queryContext.getSqlStatementContext());
            return new UpdateResponseHeader(this.queryContext.getSqlStatementContext().getSqlStatement());
        }
        ExecutionContext executionContext = this.generateExecutionContext();
        return this.isNeedImplicitCommitTransaction(this.queryContext.getSqlStatementContext().getSqlStatement(), executionContext.getExecutionUnits().size() > 1) ? (ResponseHeader)this.doExecuteWithImplicitCommitTransaction(() -> this.doExecute(executionContext)) : this.doExecute(executionContext);
    }

    private ExecutionContext generateExecutionContext() {
        ShardingSphereMetaData metaData = this.contextManager.getMetaDataContexts().getMetaData();
        return new KernelProcessor().generateExecutionContext(this.queryContext, metaData.getGlobalRuleMetaData(), metaData.getProps(), this.databaseConnectionManager.getConnectionSession().getConnectionContext());
    }

    private boolean isNeedImplicitCommitTransaction(SQLStatement sqlStatement, boolean multiExecutionUnits) {
        if (!this.databaseConnectionManager.getConnectionSession().isAutoCommit()) {
            return false;
        }
        TransactionType transactionType = TransactionUtils.getTransactionType(this.databaseConnectionManager.getConnectionSession().getConnectionContext().getTransactionContext());
        TransactionStatus transactionStatus = this.databaseConnectionManager.getConnectionSession().getTransactionStatus();
        return multiExecutionUnits && TransactionType.isDistributedTransaction((TransactionType)transactionType) && !transactionStatus.isInTransaction() && this.isWriteDMLStatement(sqlStatement);
    }

    private boolean isWriteDMLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof DMLStatement && !(sqlStatement instanceof SelectStatement);
    }

    private <T> T doExecuteWithImplicitCommitTransaction(ImplicitTransactionCallback<T> callback) throws SQLException {
        Object result;
        BackendTransactionManager transactionManager = new BackendTransactionManager(this.databaseConnectionManager);
        try {
            transactionManager.begin();
            result = callback.execute();
            transactionManager.commit();
        }
        catch (Exception ex) {
            transactionManager.rollback();
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.database.getProtocolType());
        }
        return (T)result;
    }

    private ResponseHeader doExecute(ExecutionContext executionContext) throws SQLException {
        ExecuteResult executeResultSample;
        List<ExecuteResult> executeResults;
        if (executionContext.getExecutionUnits().isEmpty()) {
            return new UpdateResponseHeader(this.queryContext.getSqlStatementContext().getSqlStatement());
        }
        this.proxySQLExecutor.checkExecutePrerequisites(executionContext);
        Collection advancedExecutors = ShardingSphereServiceLoader.getServiceInstances(AdvancedProxySQLExecutor.class);
        List<ExecuteResult> list = executeResults = advancedExecutors.isEmpty() ? this.proxySQLExecutor.execute(executionContext) : ((AdvancedProxySQLExecutor)advancedExecutors.iterator().next()).execute(executionContext, this.contextManager, this.database, this);
        if (MetaDataRefreshEngine.isRefreshMetaDataRequired((SQLStatementContext)this.queryContext.getSqlStatementContext())) {
            this.getMetaDataRefreshEngine().refresh(this.queryContext.getSqlStatementContext(), executionContext.getRouteContext().getRouteUnits());
        }
        return (executeResultSample = executeResults.iterator().next()) instanceof QueryResult ? this.processExecuteQuery(this.queryContext.getSqlStatementContext(), executeResults.stream().map(QueryResult.class::cast).collect(Collectors.toList()), (QueryResult)executeResultSample) : this.processExecuteUpdate(executeResults.stream().map(UpdateResult.class::cast).collect(Collectors.toList()));
    }

    private ResultSet doExecuteFederation() {
        boolean isReturnGeneratedKeys = this.queryContext.getSqlStatementContext().getSqlStatement() instanceof MySQLInsertStatement;
        DatabaseType protocolType = this.database.getProtocolType();
        ProxyJDBCExecutorCallback callback = ProxyJDBCExecutorCallbackFactory.newInstance(this.driverType, protocolType, this.database.getResourceMetaData(), this.queryContext.getSqlStatementContext().getSqlStatement(), this, isReturnGeneratedKeys, SQLExecutorExceptionHandler.isExceptionThrown(), true);
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine(isReturnGeneratedKeys, this.contextManager.getMetaDataContexts());
        SQLFederationContext context = new SQLFederationContext(false, this.queryContext, this.contextManager.getMetaDataContexts().getMetaData(), this.databaseConnectionManager.getConnectionSession().getProcessId());
        return this.proxySQLExecutor.getSqlFederationEngine().executeQuery(prepareEngine, (JDBCExecutorCallback)callback, context);
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine(boolean isReturnGeneratedKeys, MetaDataContexts metaData) {
        int maxConnectionsSizePerQuery = (Integer)metaData.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        JDBCBackendStatement statementManager = (JDBCBackendStatement)this.databaseConnectionManager.getConnectionSession().getStatementManager();
        return new DriverExecutionPrepareEngine(this.driverType, maxConnectionsSizePerQuery, (DatabaseConnectionManager)this.databaseConnectionManager, (ExecutorStatementManager)statementManager, (StorageResourceOption)new StatementOption(isReturnGeneratedKeys), this.database.getRuleMetaData().getRules(), this.database.getResourceMetaData().getStorageUnits());
    }

    private ResponseHeader processExecuteFederation(ResultSet resultSet) throws SQLException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        this.queryHeaders = new ArrayList<QueryHeader>(columnCount);
        QueryHeaderBuilderEngine queryHeaderBuilderEngine = new QueryHeaderBuilderEngine(null == this.database ? null : this.database.getProtocolType());
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            this.queryHeaders.add(queryHeaderBuilderEngine.build((QueryResultMetaData)new JDBCQueryResultMetaData(resultSet.getMetaData()), this.database, columnIndex));
        }
        this.mergedResult = new IteratorStreamMergedResult(Collections.singletonList(new JDBCStreamQueryResult(resultSet)));
        return new QueryResponseHeader(this.queryHeaders);
    }

    private MetaDataRefreshEngine getMetaDataRefreshEngine() {
        return new MetaDataRefreshEngine(this.contextManager.getPersistServiceFacade().getMetaDataManagerPersistService(), this.database, this.contextManager.getMetaDataContexts().getMetaData().getProps());
    }

    private QueryResponseHeader processExecuteQuery(SQLStatementContext sqlStatementContext, List<QueryResult> queryResults, QueryResult queryResultSample) throws SQLException {
        this.queryHeaders = this.createQueryHeaders(sqlStatementContext, queryResultSample);
        this.mergedResult = this.mergeQuery(sqlStatementContext, queryResults);
        return new QueryResponseHeader(this.queryHeaders);
    }

    private List<QueryHeader> createQueryHeaders(SQLStatementContext sqlStatementContext, QueryResult queryResultSample) throws SQLException {
        int columnCount = this.getColumnCount(sqlStatementContext, queryResultSample);
        ArrayList<QueryHeader> result = new ArrayList<QueryHeader>(columnCount);
        QueryHeaderBuilderEngine queryHeaderBuilderEngine = new QueryHeaderBuilderEngine(this.database.getProtocolType());
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            result.add(this.createQueryHeader(queryHeaderBuilderEngine, sqlStatementContext, queryResultSample, this.database, columnIndex));
        }
        return result;
    }

    private int getColumnCount(SQLStatementContext sqlStatementContext, QueryResult queryResultSample) throws SQLException {
        return this.containsDerivedProjections ? ((SelectStatementContext)sqlStatementContext).getProjectionsContext().getExpandProjections().size() : queryResultSample.getMetaData().getColumnCount();
    }

    private QueryHeader createQueryHeader(QueryHeaderBuilderEngine queryHeaderBuilderEngine, SQLStatementContext sqlStatementContext, QueryResult queryResultSample, ShardingSphereDatabase database, int columnIndex) throws SQLException {
        return this.containsDerivedProjections ? queryHeaderBuilderEngine.build(((SelectStatementContext)sqlStatementContext).getProjectionsContext(), queryResultSample.getMetaData(), database, columnIndex) : queryHeaderBuilderEngine.build(queryResultSample.getMetaData(), database, columnIndex);
    }

    private MergedResult mergeQuery(SQLStatementContext sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        MergeEngine mergeEngine = new MergeEngine(this.contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData(), this.database, this.contextManager.getMetaDataContexts().getMetaData().getProps(), this.databaseConnectionManager.getConnectionSession().getConnectionContext());
        return mergeEngine.merge(queryResults, sqlStatementContext);
    }

    private UpdateResponseHeader processExecuteUpdate(Collection<UpdateResult> updateResults) {
        Optional generatedKeyContext = this.queryContext.getSqlStatementContext() instanceof InsertStatementContext ? ((InsertStatementContext)this.queryContext.getSqlStatementContext()).getGeneratedKeyContext() : Optional.empty();
        Collection autoIncrementGeneratedValues = generatedKeyContext.filter(GeneratedKeyContext::isSupportAutoIncrement).map(GeneratedKeyContext::getGeneratedValues).orElseGet(Collections::emptyList);
        UpdateResponseHeader result = new UpdateResponseHeader(this.queryContext.getSqlStatementContext().getSqlStatement(), updateResults, autoIncrementGeneratedValues);
        if (this.isNeedAccumulate()) {
            result.mergeUpdateCount();
        }
        return result;
    }

    private boolean isNeedAccumulate() {
        List tableNames = this.queryContext.getSqlStatementContext() instanceof TableAvailable ? ((TableAvailable)this.queryContext.getSqlStatementContext()).getTablesContext().getTableNames() : Collections.emptyList();
        for (DataNodeRuleAttribute each : this.database.getRuleMetaData().getAttributes(DataNodeRuleAttribute.class)) {
            if (!each.isNeedAccumulate(tableNames)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public QueryResponseRow getRowData() throws SQLException {
        ArrayList<QueryResponseCell> cells = new ArrayList<QueryResponseCell>(this.queryHeaders.size());
        for (int columnIndex = 1; columnIndex <= this.queryHeaders.size(); ++columnIndex) {
            Object data = this.mergedResult.getValue(columnIndex, Object.class);
            cells.add(new QueryResponseCell(this.queryHeaders.get(columnIndex - 1).getColumnType(), data, this.queryHeaders.get(columnIndex - 1).getColumnTypeName()));
        }
        return new QueryResponseRow(cells);
    }

    @Override
    public void close() throws SQLException {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        result.addAll(this.closeResultSets());
        result.addAll(this.closeStatements());
        this.closeSQLFederationEngine().ifPresent(result::add);
        if (result.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException();
        result.forEach(ex::setNextException);
        throw ex;
    }

    private Collection<SQLException> closeResultSets() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (ResultSet each : this.cachedResultSets) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedResultSets.clear();
        return result;
    }

    private Collection<SQLException> closeStatements() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Statement each : this.cachedStatements) {
            try {
                each.cancel();
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedStatements.clear();
        return result;
    }

    private Optional<SQLException> closeSQLFederationEngine() {
        if (null != this.proxySQLExecutor.getSqlFederationEngine()) {
            try {
                this.proxySQLExecutor.getSqlFederationEngine().close();
            }
            catch (SQLException ex) {
                return Optional.of(ex);
            }
        }
        return Optional.empty();
    }
}

