/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.session;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.session.ReplayedSessionVariableProvider;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionVariableRecordExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionVariableRecordExecutor.class);
    private final DatabaseType databaseType;
    private final ConnectionSession connectionSession;

    public void recordVariable(String variableName, String assignValue) {
        if (DatabaseTypedSPILoader.findService(ReplayedSessionVariableProvider.class, (DatabaseType)this.databaseType).map(optional -> optional.isNeedToReplay(variableName)).orElse(false).booleanValue()) {
            this.connectionSession.getRequiredSessionVariableRecorder().setVariable(variableName, assignValue);
        } else {
            log.debug("Set statement {} = {} was discarded.", (Object)variableName, (Object)assignValue);
        }
    }

    public void recordVariable(Map<String, String> variables) {
        Optional replayedSessionVariableProvider = DatabaseTypedSPILoader.findService(ReplayedSessionVariableProvider.class, (DatabaseType)this.databaseType);
        if (!replayedSessionVariableProvider.isPresent()) {
            log.debug("Set statement {} was discarded.", variables);
            return;
        }
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            if (((ReplayedSessionVariableProvider)replayedSessionVariableProvider.get()).isNeedToReplay(entry.getKey())) {
                this.connectionSession.getRequiredSessionVariableRecorder().setVariable(entry.getKey(), entry.getValue());
                continue;
            }
            log.debug("Set statement {} = {} was discarded.", (Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    @Generated
    public SessionVariableRecordExecutor(DatabaseType databaseType, ConnectionSession connectionSession) {
        this.databaseType = databaseType;
        this.connectionSession = connectionSession;
    }
}

