/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.internal;

import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.jdbc.internal.AbstractJdbcConnectionProxy;
import com.atomikos.jdbc.internal.AtomikosSQLException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import com.atomikos.util.Proxied;
import java.sql.Connection;
import java.sql.SQLException;

public class AtomikosJdbcConnectionProxy
extends AbstractJdbcConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosJdbcConnectionProxy.class);
    private final SessionHandleState sessionHandleState;
    private final boolean localTransactionMode;

    public AtomikosJdbcConnectionProxy(Connection delegate, SessionHandleState sessionHandleState, boolean localTransactionMode) {
        super(delegate);
        this.sessionHandleState = sessionHandleState;
        sessionHandleState.notifySessionBorrowed();
        this.localTransactionMode = localTransactionMode;
    }

    private CompositeTransactionManager getCompositeTransactionManager() {
        CompositeTransactionManager ret = Configuration.getCompositeTransactionManager();
        if (ret == null) {
            LOGGER.logWarning((Object)((Object)this) + ": WARNING: transaction manager not running?");
        }
        return ret;
    }

    @Override
    protected boolean isEnlistedInGlobalTransaction() {
        CompositeTransactionManager compositeTransactionManager = this.getCompositeTransactionManager();
        if (compositeTransactionManager == null) {
            return false;
        }
        CompositeTransaction ct = compositeTransactionManager.getCompositeTransaction();
        return this.sessionHandleState.isActiveInTransaction(ct);
    }

    @Override
    protected void updateTransactionContext() throws SQLException {
        try {
            this.enlist();
        }
        catch (Exception e) {
            this.sessionHandleState.notifySessionErrorOccurred();
            LOGGER.logWarning("Error enlisting in transaction - connection might be broken? Please check the logs for more information...", (Throwable)e);
            throw e;
        }
    }

    private boolean enlist() throws AtomikosSQLException {
        boolean ret = false;
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": notifyBeforeUse " + this.sessionHandleState);
            }
            CompositeTransaction ct = null;
            CompositeTransactionManager ctm = this.getCompositeTransactionManager();
            if (ctm != null) {
                ct = ctm.getCompositeTransaction();
                this.sessionHandleState.notifyBeforeUse(ct);
                if (ct != null && TransactionManagerImp.isJtaTransaction((CompositeTransaction)ct)) {
                    ret = true;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.logTrace((Object)((Object)this) + ": detected transaction " + ct);
                    }
                    if (ct.getState().equals((Object)TxState.ACTIVE)) {
                        ct.registerSynchronization((Synchronization)new JdbcRequeueSynchronization(this, ct));
                    } else {
                        AtomikosSQLException.throwAtomikosSQLException("The transaction has timed out - try increasing the timeout if needed");
                    }
                } else if (!this.localTransactionMode) {
                    AtomikosSQLException.throwAtomikosSQLException("A JTA transaction is required but none was found - please start one first (or set localTransactionMode=true to allow JDBC transactions)");
                }
            }
        }
        catch (InvalidSessionHandleStateException ex) {
            AtomikosSQLException.throwAtomikosSQLException(ex.getMessage(), ex);
        }
        return ret;
    }

    @Proxied
    public void close() throws SQLException {
        this.forceCloseAllPendingStatements(false);
        this.markClosed();
        this.sessionHandleState.notifySessionClosed();
    }

    protected void handleInvocationException(Throwable e) throws Throwable {
        this.sessionHandleState.notifySessionErrorOccurred();
        throw e;
    }

    public String toString() {
        return "atomikosJdbcConnectionProxy (state = " + this.sessionHandleState + ") for vendor instance " + this.delegate;
    }

    protected Class<Connection> getRequiredInterfaceType() {
        return Connection.class;
    }

    private class JdbcRequeueSynchronization
    implements Synchronization {
        private CompositeTransaction compositeTransaction;
        private AtomikosJdbcConnectionProxy proxy;
        private boolean afterCompletionDone;

        public JdbcRequeueSynchronization(AtomikosJdbcConnectionProxy proxy, CompositeTransaction compositeTransaction) {
            this.compositeTransaction = compositeTransaction;
            this.proxy = proxy;
            this.afterCompletionDone = false;
        }

        public void afterCompletion(TxState state) {
            if (this.afterCompletionDone) {
                return;
            }
            if (state == TxState.ABORTING) {
                AtomikosJdbcConnectionProxy.this.forceCloseAllPendingStatements(true);
            }
            if (state == TxState.TERMINATED || state.isHeuristic()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace((Object)((Object)this.proxy) + ": detected termination of transaction " + this.compositeTransaction);
                }
                AtomikosJdbcConnectionProxy.this.sessionHandleState.notifyTransactionTerminated(this.compositeTransaction);
                this.afterCompletionDone = true;
                AtomikosJdbcConnectionProxy.this.forceCloseAllPendingStatements(false);
            }
        }

        public void beforeCompletion() {
        }

        public boolean equals(Object other) {
            boolean ret = false;
            if (other instanceof JdbcRequeueSynchronization) {
                JdbcRequeueSynchronization o = (JdbcRequeueSynchronization)other;
                ret = this.compositeTransaction.isSameTransaction(o.compositeTransaction);
            }
            return ret;
        }

        public int hashCode() {
            return this.compositeTransaction.hashCode();
        }
    }
}

