/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.api;

import com.google.common.base.Strings;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.pojo.ConsistencyCheckJobItemInfo;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableDataConsistencyCheckerFactory;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.exception.data.UnsupportedPipelineDatabaseTypeException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.UncompletedConsistencyCheckJobExistsException;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobId;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.ConsistencyCheckJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlConsistencyCheckJobItemProgressSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlPipelineJobItemProgressSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobConfigurationManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.registrycenter.repository.PipelineGovernanceFacade;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobId;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobType;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.api.CreateConsistencyCheckJobParameter;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.config.ConsistencyCheckJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.config.yaml.config.YamlConsistencyCheckJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.config.yaml.swapper.YamlConsistencyCheckJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.util.ConsistencyCheckSequence;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.datetime.DateTimeFormatterFactory;

public final class ConsistencyCheckJobAPI {
    private final YamlConsistencyCheckJobItemProgressSwapper progressSwapper;
    private final PipelineJobManager jobManager;
    private final PipelineJobConfigurationManager jobConfigManager;
    private final PipelineJobItemManager<ConsistencyCheckJobItemProgress> jobItemManager;

    public ConsistencyCheckJobAPI(ConsistencyCheckJobType jobType) {
        this.progressSwapper = jobType.getYamlJobItemProgressSwapper();
        this.jobManager = new PipelineJobManager((PipelineJobType)jobType);
        this.jobConfigManager = new PipelineJobConfigurationManager((PipelineJobType)jobType);
        this.jobItemManager = new PipelineJobItemManager((YamlPipelineJobItemProgressSwapper)this.progressSwapper);
    }

    public String start(CreateConsistencyCheckJobParameter param) {
        String parentJobId = param.getParentJobId();
        PipelineGovernanceFacade governanceFacade = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)parentJobId));
        Optional latestCheckJobId = governanceFacade.getJobFacade().getCheck().findLatestCheckJobId(parentJobId);
        if (latestCheckJobId.isPresent()) {
            Optional progress = new PipelineJobItemManager((YamlPipelineJobItemProgressSwapper)this.progressSwapper).getProgress((String)latestCheckJobId.get(), 0);
            ShardingSpherePreconditions.checkState((progress.isPresent() && (JobStatus.FINISHED == ((ConsistencyCheckJobItemProgress)progress.get()).getStatus() || JobStatus.CONSISTENCY_CHECK_FAILURE == ((ConsistencyCheckJobItemProgress)progress.get()).getStatus()) ? 1 : 0) != 0, () -> new UncompletedConsistencyCheckJobExistsException((String)latestCheckJobId.get(), (ConsistencyCheckJobItemProgress)progress.orElse(null)));
        }
        this.checkPipelineDatabaseTypes(param);
        PipelineContextKey contextKey = PipelineJobIdUtils.parseContextKey((String)parentJobId);
        String result = PipelineJobIdUtils.marshal((PipelineJobId)latestCheckJobId.map(optional -> new ConsistencyCheckJobId(contextKey, parentJobId, (String)optional)).orElseGet(() -> new ConsistencyCheckJobId(contextKey, parentJobId)));
        governanceFacade.getJobFacade().getCheck().persistLatestCheckJobId(parentJobId, result);
        governanceFacade.getJobFacade().getCheck().initCheckJobResult(parentJobId, result);
        this.jobManager.drop(result);
        this.jobManager.start((PipelineJobConfiguration)new YamlConsistencyCheckJobConfigurationSwapper().swapToObject(this.getYamlConfiguration(result, parentJobId, param)));
        return result;
    }

    private void checkPipelineDatabaseTypes(CreateConsistencyCheckJobParameter param) {
        Collection supportedDatabaseTypes;
        try (TableDataConsistencyChecker checker = TableDataConsistencyCheckerFactory.newInstance((String)param.getAlgorithmTypeName(), (Properties)param.getAlgorithmProps());){
            supportedDatabaseTypes = checker.getSupportedDatabaseTypes();
        }
        ShardingSpherePreconditions.checkContains((Collection)supportedDatabaseTypes, (Object)param.getSourceDatabaseType(), () -> new UnsupportedPipelineDatabaseTypeException(param.getSourceDatabaseType()));
        ShardingSpherePreconditions.checkContains((Collection)supportedDatabaseTypes, (Object)param.getTargetDatabaseType(), () -> new UnsupportedPipelineDatabaseTypeException(param.getTargetDatabaseType()));
    }

    private YamlConsistencyCheckJobConfiguration getYamlConfiguration(String jobId, String parentJobId, CreateConsistencyCheckJobParameter param) {
        YamlConsistencyCheckJobConfiguration result = new YamlConsistencyCheckJobConfiguration();
        result.setJobId(jobId);
        result.setParentJobId(parentJobId);
        result.setAlgorithmTypeName(param.getAlgorithmTypeName());
        result.setAlgorithmProps(param.getAlgorithmProps());
        result.setSourceDatabaseType(param.getSourceDatabaseType().getType());
        return result;
    }

    public void resume(String parentJobId) {
        this.jobManager.resume(PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)parentJobId)).getJobFacade().getCheck().getLatestCheckJobId(parentJobId));
    }

    public void stop(String parentJobId) {
        this.jobManager.stop(PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)parentJobId)).getJobFacade().getCheck().getLatestCheckJobId(parentJobId));
    }

    public void drop(String parentJobId) {
        String latestCheckJobId = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)parentJobId)).getJobFacade().getCheck().getLatestCheckJobId(parentJobId);
        this.jobManager.stop(latestCheckJobId);
        PipelineContextKey contextKey = PipelineJobIdUtils.parseContextKey((String)parentJobId);
        PipelineGovernanceFacade governanceFacade = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)contextKey);
        Collection checkJobIds = governanceFacade.getJobFacade().getCheck().listCheckJobIds(parentJobId);
        Optional<Integer> previousSequence = ConsistencyCheckSequence.getPreviousSequence(checkJobIds.stream().map(ConsistencyCheckJobId::parseSequence).collect(Collectors.toList()), ConsistencyCheckJobId.parseSequence(latestCheckJobId));
        if (previousSequence.isPresent()) {
            String checkJobId = PipelineJobIdUtils.marshal((PipelineJobId)new ConsistencyCheckJobId(contextKey, parentJobId, previousSequence.get()));
            governanceFacade.getJobFacade().getCheck().persistLatestCheckJobId(parentJobId, checkJobId);
        } else {
            governanceFacade.getJobFacade().getCheck().deleteLatestCheckJobId(parentJobId);
        }
        governanceFacade.getJobFacade().getCheck().deleteCheckJobResult(parentJobId, latestCheckJobId);
        this.jobManager.drop(latestCheckJobId);
    }

    public List<ConsistencyCheckJobItemInfo> getJobItemInfos(String parentJobId) {
        String latestCheckJobId = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)parentJobId)).getJobFacade().getCheck().getLatestCheckJobId(parentJobId);
        return this.jobItemManager.getProgress(latestCheckJobId, 0).map(optional -> this.getJobItemInfos(parentJobId, latestCheckJobId, (ConsistencyCheckJobItemProgress)optional)).orElse(Collections.emptyList());
    }

    private List<ConsistencyCheckJobItemInfo> getJobItemInfos(String parentJobId, String latestCheckJobId, ConsistencyCheckJobItemProgress progress) {
        LinkedList<ConsistencyCheckJobItemInfo> result = new LinkedList<ConsistencyCheckJobItemInfo>();
        if (!Strings.isNullOrEmpty((String)progress.getIgnoredTableNames())) {
            PipelineGovernanceFacade governanceFacade = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)parentJobId));
            Map checkJobResult = governanceFacade.getJobFacade().getCheck().getCheckJobResult(parentJobId, latestCheckJobId);
            result.addAll(this.getJobItemInfosWithIgnoredTables(progress.getIgnoredTableNames().split(","), checkJobResult));
        }
        if (Objects.equals(progress.getIgnoredTableNames(), progress.getTableNames())) {
            return result;
        }
        result.add(this.getJobItemInfo(parentJobId, latestCheckJobId));
        return result;
    }

    private List<ConsistencyCheckJobItemInfo> getJobItemInfosWithIgnoredTables(String[] ignoredTables, Map<String, TableDataConsistencyCheckResult> checkJobResult) {
        LinkedList<ConsistencyCheckJobItemInfo> result = new LinkedList<ConsistencyCheckJobItemInfo>();
        for (String each : ignoredTables) {
            ConsistencyCheckJobItemInfo info = new ConsistencyCheckJobItemInfo();
            info.setTableNames(each);
            info.setCheckSuccess(null);
            TableDataConsistencyCheckResult checkResult = checkJobResult.get(each);
            if (null != checkResult && checkResult.isIgnored()) {
                info.setErrorMessage(checkResult.getIgnoredType().getMessage());
            }
            result.add(info);
        }
        return result;
    }

    private ConsistencyCheckJobItemInfo getJobItemInfo(String parentJobId, String latestCheckJobId) {
        ConsistencyCheckJobItemInfo result = new ConsistencyCheckJobItemInfo();
        JobConfigurationPOJO jobConfigPOJO = PipelineJobIdUtils.getElasticJobConfigurationPOJO((String)latestCheckJobId);
        result.setActive(!jobConfigPOJO.isDisabled());
        Optional progress = this.jobItemManager.getProgress(latestCheckJobId, 0);
        if (!progress.isPresent()) {
            return result;
        }
        ConsistencyCheckJobItemProgress jobItemProgress = (ConsistencyCheckJobItemProgress)progress.get();
        if (null == jobItemProgress.getRecordsCount() || null == jobItemProgress.getCheckedRecordsCount()) {
            result.setInventoryFinishedPercentage(0);
            result.setCheckSuccess(null);
            return result;
        }
        this.fillInJobItemInfoWithTimes(result, jobItemProgress, jobConfigPOJO);
        result.setTableNames(Optional.ofNullable(jobItemProgress.getTableNames()).orElse(""));
        this.fillInJobItemInfoWithCheckAlgorithm(result, latestCheckJobId);
        result.setErrorMessage(PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)latestCheckJobId)).getJobItemFacade().getErrorMessage().load(latestCheckJobId, 0));
        Map checkJobResults = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)parentJobId)).getJobFacade().getCheck().getCheckJobResult(parentJobId, latestCheckJobId);
        result.setCheckSuccess(checkJobResults.isEmpty() ? null : Boolean.valueOf(checkJobResults.values().stream().allMatch(TableDataConsistencyCheckResult::isMatched)));
        result.setCheckFailedTableNames(checkJobResults.entrySet().stream().filter(each -> !((TableDataConsistencyCheckResult)each.getValue()).isIgnored() && !((TableDataConsistencyCheckResult)each.getValue()).isMatched()).map(Map.Entry::getKey).collect(Collectors.joining(",")));
        return result;
    }

    private void fillInJobItemInfoWithTimes(ConsistencyCheckJobItemInfo result, ConsistencyCheckJobItemProgress jobItemProgress, JobConfigurationPOJO jobConfigPOJO) {
        long recordsCount = jobItemProgress.getRecordsCount();
        long checkedRecordsCount = Math.min(jobItemProgress.getCheckedRecordsCount(), recordsCount);
        LocalDateTime checkBeginTime = new Timestamp(jobItemProgress.getCheckBeginTimeMillis()).toLocalDateTime();
        result.setCheckBeginTime(DateTimeFormatterFactory.getLongMillsFormatter().format(checkBeginTime));
        if (JobStatus.FINISHED == jobItemProgress.getStatus()) {
            result.setInventoryFinishedPercentage(100);
            LocalDateTime checkEndTime = new Timestamp(jobItemProgress.getCheckEndTimeMillis()).toLocalDateTime();
            Duration duration = Duration.between(checkBeginTime, checkEndTime);
            result.setDurationSeconds(duration.getSeconds());
            result.setCheckEndTime(DateTimeFormatterFactory.getLongMillsFormatter().format(checkEndTime));
            result.setInventoryRemainingSeconds(0L);
        } else if (0L != recordsCount && 0L != checkedRecordsCount) {
            result.setInventoryFinishedPercentage((int)(checkedRecordsCount * 100L / recordsCount));
            LocalDateTime stopTime = jobConfigPOJO.isDisabled() ? LocalDateTime.from(DateTimeFormatterFactory.getStandardFormatter().parse(jobConfigPOJO.getProps().getProperty("stop_time"))) : null;
            long durationMillis = (null != stopTime ? Timestamp.valueOf(stopTime).getTime() : System.currentTimeMillis()) - jobItemProgress.getCheckBeginTimeMillis();
            result.setDurationSeconds(TimeUnit.MILLISECONDS.toSeconds(durationMillis));
            if (null != stopTime) {
                result.setCheckEndTime(jobConfigPOJO.getProps().getProperty("stop_time"));
            }
            long remainingMills = Math.max(0L, (long)((double)(recordsCount - checkedRecordsCount) * 1.0 / (double)checkedRecordsCount * (double)durationMillis));
            result.setInventoryRemainingSeconds(remainingMills / 1000L);
        }
    }

    private void fillInJobItemInfoWithCheckAlgorithm(ConsistencyCheckJobItemInfo result, String checkJobId) {
        ConsistencyCheckJobConfiguration jobConfig = (ConsistencyCheckJobConfiguration)this.jobConfigManager.getJobConfiguration(checkJobId);
        result.setAlgorithmType(jobConfig.getAlgorithmTypeName());
        if (null != jobConfig.getAlgorithmProps()) {
            result.setAlgorithmProps(jobConfig.getAlgorithmProps().entrySet().stream().map(entry -> String.format("'%s'='%s'", entry.getKey(), entry.getValue())).collect(Collectors.joining(",")));
        }
    }
}

