/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.admin.initdb;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.admin.initdb.MySQLComInitDbPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.ServerStatusFlagCalculator;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;

public final class MySQLComInitDbExecutor
implements CommandExecutor {
    private final MySQLComInitDbPacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() {
        String databaseName = SQLUtils.getExactlyValue((String)this.packet.getSchema());
        AuthorityRule authorityRule = (AuthorityRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        AuthorityChecker authorityChecker = new AuthorityChecker(authorityRule, this.connectionSession.getConnectionContext().getGrantee());
        ShardingSpherePreconditions.checkState((ProxyContext.getInstance().databaseExists(databaseName) && authorityChecker.isAuthorized(databaseName) ? 1 : 0) != 0, () -> new UnknownDatabaseException(this.packet.getSchema()));
        this.connectionSession.setCurrentDatabaseName(this.packet.getSchema());
        return Collections.singleton(new MySQLOKPacket(ServerStatusFlagCalculator.calculateFor(this.connectionSession)));
    }

    @Generated
    public MySQLComInitDbExecutor(MySQLComInitDbPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

