/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.distsql.segment;

import lombok.Generated;
import org.apache.shardingsphere.distsql.segment.DistSQLSegment;
import org.apache.shardingsphere.infra.metadata.caseinsensitive.CaseInsensitiveIdentifier;

public final class SingleTableSegment
implements DistSQLSegment {
    private final CaseInsensitiveIdentifier storageUnitName;
    private final CaseInsensitiveIdentifier schemaName;
    private final CaseInsensitiveIdentifier tableName;

    public SingleTableSegment(String storageUnitName, String tableName) {
        this(storageUnitName, null, tableName);
    }

    public SingleTableSegment(String storageUnitName, String schemaName, String tableName) {
        this.storageUnitName = new CaseInsensitiveIdentifier(storageUnitName);
        this.schemaName = null == schemaName ? null : new CaseInsensitiveIdentifier(schemaName);
        this.tableName = new CaseInsensitiveIdentifier(tableName);
    }

    public String getStorageUnitName() {
        return this.storageUnitName.toString();
    }

    public String getTableName() {
        return this.tableName.toString();
    }

    public boolean containsSchema() {
        return null != this.schemaName;
    }

    public String toString() {
        return null == this.schemaName ? String.join((CharSequence)".", this.getStorageUnitName(), this.getTableName()) : String.join((CharSequence)".", this.getStorageUnitName(), this.schemaName.toString(), this.getTableName());
    }

    @Generated
    public SingleTableSegment(CaseInsensitiveIdentifier storageUnitName, CaseInsensitiveIdentifier schemaName, CaseInsensitiveIdentifier tableName) {
        this.storageUnitName = storageUnitName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleTableSegment)) {
            return false;
        }
        SingleTableSegment other = (SingleTableSegment)o;
        String this$storageUnitName = this.getStorageUnitName();
        String other$storageUnitName = other.getStorageUnitName();
        if (this$storageUnitName == null ? other$storageUnitName != null : !this$storageUnitName.equals(other$storageUnitName)) {
            return false;
        }
        CaseInsensitiveIdentifier this$schemaName = this.schemaName;
        CaseInsensitiveIdentifier other$schemaName = other.schemaName;
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $storageUnitName = this.getStorageUnitName();
        result = result * 59 + ($storageUnitName == null ? 43 : $storageUnitName.hashCode());
        CaseInsensitiveIdentifier $schemaName = this.schemaName;
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        return result;
    }
}

