/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.datanode;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.mapper.ActualAndLogicTableNameMapper;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.caseinsensitive.CaseInsensitiveIdentifier;

public final class JobDataNodeLineConvertUtils {
    public static List<JobDataNodeLine> convertDataNodesToLines(Map<String, List<DataNode>> actualDataNodes) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Map.Entry<String, Map<String, List<DataNode>>> entry : JobDataNodeLineConvertUtils.groupDataSourceDataNodesMapByDataSourceName(actualDataNodes).entrySet()) {
            result.add(Pair.of((Object)entry.getKey(), (Object)new JobDataNodeLine(JobDataNodeLineConvertUtils.getJobDataNodeEntries(entry.getValue()))));
        }
        result.sort(Map.Entry.comparingByKey());
        return result.stream().map(Pair::getValue).collect(Collectors.toList());
    }

    private static List<JobDataNodeEntry> getJobDataNodeEntries(Map<String, List<DataNode>> dataNodeMap) {
        return dataNodeMap.entrySet().stream().map(entry -> new JobDataNodeEntry((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    private static Map<String, Map<String, List<DataNode>>> groupDataSourceDataNodesMapByDataSourceName(Map<String, List<DataNode>> actualDataNodes) {
        LinkedHashMap<String, Map<String, List<DataNode>>> result = new LinkedHashMap<String, Map<String, List<DataNode>>>();
        for (Map.Entry<String, List<DataNode>> entry : actualDataNodes.entrySet()) {
            for (DataNode each : entry.getValue()) {
                Map groupedDataNodesMap = result.computeIfAbsent(each.getDataSourceName(), key -> new LinkedHashMap());
                groupedDataNodesMap.computeIfAbsent(entry.getKey(), key -> new LinkedList()).add(each);
            }
        }
        return result;
    }

    public static ActualAndLogicTableNameMapper buildTableNameMapper(JobDataNodeLine dataNodeLine) {
        LinkedHashMap<CaseInsensitiveIdentifier, CaseInsensitiveIdentifier> map = new LinkedHashMap<CaseInsensitiveIdentifier, CaseInsensitiveIdentifier>();
        for (JobDataNodeEntry each : dataNodeLine.getEntries()) {
            for (DataNode dataNode : each.getDataNodes()) {
                map.put(new CaseInsensitiveIdentifier(dataNode.getTableName()), new CaseInsensitiveIdentifier(each.getLogicTableName()));
            }
        }
        return new ActualAndLogicTableNameMapper(map);
    }

    @Generated
    private JobDataNodeLineConvertUtils() {
    }
}

