/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.statement;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;

public enum SQLStatementType {
    DML,
    DDL,
    TCL,
    DCL,
    DAL,
    RL;

    private static final Collection<Class<? extends SQLStatement>> INVOLVE_DATA_CHANGES_STATEMENTS;
    private static final Collection<Class<? extends SQLStatement>> NOT_INVOLVE_DATA_CHANGES_STATEMENTS;

    public static boolean involvesDataChanges(SQLStatement sqlStatement) {
        Class<?> sqlStatementClass = sqlStatement.getClass();
        if (NOT_INVOLVE_DATA_CHANGES_STATEMENTS.contains(sqlStatementClass)) {
            return false;
        }
        if (INVOLVE_DATA_CHANGES_STATEMENTS.contains(sqlStatementClass)) {
            return true;
        }
        if (sqlStatement instanceof SelectStatement) {
            NOT_INVOLVE_DATA_CHANGES_STATEMENTS.add(sqlStatementClass);
            return false;
        }
        if (sqlStatement instanceof DMLStatement || sqlStatement instanceof DDLStatement) {
            INVOLVE_DATA_CHANGES_STATEMENTS.add(sqlStatementClass);
            return true;
        }
        NOT_INVOLVE_DATA_CHANGES_STATEMENTS.add(sqlStatementClass);
        return false;
    }

    static {
        INVOLVE_DATA_CHANGES_STATEMENTS = Collections.newSetFromMap(new ConcurrentHashMap());
        NOT_INVOLVE_DATA_CHANGES_STATEMENTS = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

