/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.task;

import java.util.Collection;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.core.task.runner.PipelineTasksRunner;
import org.apache.shardingsphere.infra.util.close.QuietlyCloser;

public final class CDCTasksRunner
implements PipelineTasksRunner {
    private final TransmissionJobItemContext jobItemContext;
    private final Collection<PipelineTask> inventoryTasks;
    private final Collection<PipelineTask> incrementalTasks;

    public CDCTasksRunner(TransmissionJobItemContext jobItemContext) {
        this.jobItemContext = jobItemContext;
        this.inventoryTasks = jobItemContext.getInventoryTasks();
        this.incrementalTasks = jobItemContext.getIncrementalTasks();
    }

    public PipelineJobItemContext getJobItemContext() {
        return this.jobItemContext;
    }

    public void start() {
    }

    public void stop() {
        this.jobItemContext.setStopping(true);
        for (PipelineTask each : this.inventoryTasks) {
            each.stop();
            QuietlyCloser.close((AutoCloseable)each);
        }
        for (PipelineTask each : this.incrementalTasks) {
            each.stop();
            QuietlyCloser.close((AutoCloseable)each);
        }
    }
}

