/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.config.database;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.mode.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.node.path.metadata.DataSourceMetaDataNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class DataSourceNodePersistService {
    private final PersistRepository repository;
    private final MetaDataVersionPersistService metaDataVersionPersistService;

    public DataSourceNodePersistService(PersistRepository repository) {
        this.repository = repository;
        this.metaDataVersionPersistService = new MetaDataVersionPersistService(repository);
    }

    public Map<String, DataSourcePoolProperties> load(String databaseName) {
        List childrenKeys = this.repository.getChildrenKeys(DataSourceMetaDataNodePath.getStorageNodesPath((String)databaseName));
        LinkedHashMap<String, DataSourcePoolProperties> result = new LinkedHashMap<String, DataSourcePoolProperties>(childrenKeys.size(), 1.0f);
        for (String each : childrenKeys) {
            String dataSourceValue = this.repository.query(DataSourceMetaDataNodePath.getStorageNodeVersionPath((String)databaseName, (String)each, (String)this.getDataSourceActiveVersion(databaseName, each)));
            if (Strings.isNullOrEmpty((String)dataSourceValue)) continue;
            result.put(each, new YamlDataSourceConfigurationSwapper().swapToDataSourcePoolProperties((Map)YamlEngine.unmarshal((String)dataSourceValue, Map.class)));
        }
        return result;
    }

    public DataSourcePoolProperties load(String databaseName, String dataSourceName) {
        String dataSourceValue = this.repository.query(DataSourceMetaDataNodePath.getStorageNodeVersionPath((String)databaseName, (String)dataSourceName, (String)this.getDataSourceActiveVersion(databaseName, dataSourceName)));
        return new YamlDataSourceConfigurationSwapper().swapToDataSourcePoolProperties((Map)YamlEngine.unmarshal((String)dataSourceValue, Map.class));
    }

    public void persist(String databaseName, Map<String, DataSourcePoolProperties> dataSourceConfigs) {
        for (Map.Entry<String, DataSourcePoolProperties> entry : dataSourceConfigs.entrySet()) {
            List<String> versions;
            String activeVersion = this.getDataSourceActiveVersion(databaseName, entry.getKey());
            this.repository.persist(DataSourceMetaDataNodePath.getStorageNodeVersionPath((String)databaseName, (String)entry.getKey(), (String)((versions = this.metaDataVersionPersistService.getVersions(DataSourceMetaDataNodePath.getStorageNodeVersionsPath((String)databaseName, (String)entry.getKey()))).isEmpty() ? "0" : String.valueOf(Integer.parseInt(versions.get(0)) + 1))), YamlEngine.marshal((Object)new YamlDataSourceConfigurationSwapper().swapToMap(entry.getValue())));
            if (!Strings.isNullOrEmpty((String)activeVersion)) continue;
            this.repository.persist(DataSourceMetaDataNodePath.getStorageNodeActiveVersionPath((String)databaseName, (String)entry.getKey()), "0");
        }
    }

    private String getDataSourceActiveVersion(String databaseName, String dataSourceName) {
        return this.repository.query(DataSourceMetaDataNodePath.getStorageNodeActiveVersionPath((String)databaseName, (String)dataSourceName));
    }

    public void delete(String databaseName, String dataSourceName) {
        this.repository.delete(DataSourceMetaDataNodePath.getStorageNodePath((String)databaseName, (String)dataSourceName));
    }
}

