/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.util;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.table.TableMapperRuleAttribute;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class TableRefreshUtils {
    public static String getTableName(DatabaseType databaseType, IdentifierValue identifierValue) {
        return QuoteCharacter.NONE == identifierValue.getQuoteCharacter() ? new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().formatTableNamePattern(identifierValue.getValue()) : identifierValue.getValue();
    }

    public static boolean isSingleTable(String tableName, ShardingSphereDatabase database) {
        return database.getRuleMetaData().getAttributes(TableMapperRuleAttribute.class).stream().noneMatch(each -> each.getDistributedTableNames().contains(tableName));
    }

    public static boolean isRuleRefreshRequired(RuleMetaData ruleMetaData, String schemaName, Collection<SimpleTableSegment> tableSegments) {
        for (SimpleTableSegment each : tableSegments) {
            if (!TableRefreshUtils.isRuleRefreshRequired(ruleMetaData, schemaName, each.getTableName().getIdentifier().getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRuleRefreshRequired(RuleMetaData ruleMetaData, String schemaName, String tableName) {
        LinkedList rules = new LinkedList();
        for (ShardingSphereRule each : ruleMetaData.getRules()) {
            each.getAttributes().findAttribute(MutableDataNodeRuleAttribute.class).ifPresent(optional -> rules.add(each));
        }
        if (rules.isEmpty()) {
            return false;
        }
        ShardingSphereRule rule = (ShardingSphereRule)rules.iterator().next();
        RuleConfiguration ruleConfig = rule.getConfiguration();
        if (!(ruleConfig instanceof SingleRuleConfiguration)) {
            return false;
        }
        Collection tablesConfig = ((SingleRuleConfiguration)ruleConfig).getTables();
        if (tablesConfig.contains("*.*") || tablesConfig.contains("*.*.*")) {
            return false;
        }
        Optional dataNode = ((MutableDataNodeRuleAttribute)rule.getAttributes().getAttribute(MutableDataNodeRuleAttribute.class)).findTableDataNode(schemaName, tableName);
        if (!dataNode.isPresent()) {
            return false;
        }
        DataNode actualNode = (DataNode)dataNode.get();
        return !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), "*")) && !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), "*", "*")) && !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), actualNode.getSchemaName(), "*"));
    }

    private static String joinDataNodeSegments(String ... segments) {
        return Joiner.on((String)".").join((Object[])segments);
    }

    @Generated
    private TableRefreshUtils() {
    }
}

