/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.props.validator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.checker.DialectDatabasePrivilegeChecker;
import org.apache.shardingsphere.infra.database.core.checker.PrivilegeCheckType;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.datasource.pool.props.validator.DataSourcePoolPropertiesContentValidator;
import org.apache.shardingsphere.infra.datasource.pool.props.validator.InvalidDataSourcePoolPropertiesException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class DataSourcePoolPropertiesValidator {
    public static Map<String, Exception> validate(Map<String, DataSourcePoolProperties> propsMap, Collection<PrivilegeCheckType> expectedPrivileges) {
        LinkedHashMap<String, Exception> result = new LinkedHashMap<String, Exception>(propsMap.size(), 1.0f);
        for (Map.Entry<String, DataSourcePoolProperties> entry : propsMap.entrySet()) {
            try {
                DataSourcePoolPropertiesValidator.validateProperties(entry.getKey(), entry.getValue());
                DataSourcePoolPropertiesValidator.validateConnection(entry.getKey(), entry.getValue(), expectedPrivileges);
            }
            catch (InvalidDataSourcePoolPropertiesException ex) {
                result.put(entry.getKey(), (Exception)((Object)ex));
            }
        }
        return result;
    }

    private static void validateProperties(String dataSourceName, DataSourcePoolProperties props) throws InvalidDataSourcePoolPropertiesException {
        try {
            TypedSPILoader.findService(DataSourcePoolPropertiesContentValidator.class, (Object)props.getPoolClassName()).ifPresent(optional -> optional.validate(props));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidDataSourcePoolPropertiesException(dataSourceName, ex.getMessage());
        }
    }

    private static void validateConnection(String dataSourceName, DataSourcePoolProperties props, Collection<PrivilegeCheckType> expectedPrivileges) throws InvalidDataSourcePoolPropertiesException {
        DataSource dataSource = null;
        try {
            dataSource = DataSourcePoolCreator.create(props);
            if (expectedPrivileges.isEmpty() || expectedPrivileges.contains(PrivilegeCheckType.NONE)) {
                DataSourcePoolPropertiesValidator.checkFailFast(dataSource);
                return;
            }
            DataSourcePoolPropertiesValidator.checkPrivileges(dataSource, props, expectedPrivileges);
        }
        catch (RuntimeException | SQLException ex) {
            throw new InvalidDataSourcePoolPropertiesException(dataSourceName, ex.getMessage());
        }
        finally {
            if (null != dataSource) {
                new DataSourcePoolDestroyer(dataSource).asyncDestroy();
            }
        }
    }

    private static void checkFailFast(DataSource dataSource) throws SQLException {
        Connection ignored = dataSource.getConnection();
        if (ignored != null) {
            ignored.close();
        }
    }

    private static void checkPrivileges(DataSource dataSource, DataSourcePoolProperties props, Collection<PrivilegeCheckType> expectedPrivileges) {
        DatabaseType databaseType = DatabaseTypeFactory.get((String)((String)props.getConnectionPropertySynonyms().getStandardProperties().get("url")));
        Optional checker = DatabaseTypedSPILoader.findService(DialectDatabasePrivilegeChecker.class, (DatabaseType)databaseType);
        if (checker.isPresent()) {
            for (PrivilegeCheckType each : expectedPrivileges) {
                ((DialectDatabasePrivilegeChecker)checker.get()).check(dataSource, each);
            }
        }
    }

    @Generated
    private DataSourcePoolPropertiesValidator() {
    }
}

