/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.retriever.dml;

import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.context.statement.dml.DeleteStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.shadow.route.retriever.ShadowDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.route.retriever.dml.table.column.ShadowColumnDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.route.retriever.dml.table.column.impl.ShadowDeleteStatementDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.route.retriever.dml.table.column.impl.ShadowInsertStatementDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.route.retriever.dml.table.column.impl.ShadowSelectStatementDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.route.retriever.dml.table.column.impl.ShadowUpdateStatementDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.route.retriever.dml.table.hint.ShadowTableHintDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;

public final class ShadowDMLStatementDataSourceMappingsRetriever
implements ShadowDataSourceMappingsRetriever {
    private final Collection<String> tableNames;
    private final ShadowTableHintDataSourceMappingsRetriever tableHintDataSourceMappingsRetriever;
    private final ShadowColumnDataSourceMappingsRetriever shadowColumnDataSourceMappingsRetriever;

    public ShadowDMLStatementDataSourceMappingsRetriever(QueryContext queryContext, ShadowOperationType operationType) {
        this.tableNames = ((TableAvailable)queryContext.getSqlStatementContext()).getTablesContext().getTableNames();
        this.tableHintDataSourceMappingsRetriever = new ShadowTableHintDataSourceMappingsRetriever(operationType, queryContext.getHintValueContext().isShadow());
        this.shadowColumnDataSourceMappingsRetriever = this.createShadowDataSourceMappingsRetriever(queryContext);
    }

    private ShadowColumnDataSourceMappingsRetriever createShadowDataSourceMappingsRetriever(QueryContext queryContext) {
        if (queryContext.getSqlStatementContext() instanceof InsertStatementContext) {
            return new ShadowInsertStatementDataSourceMappingsRetriever((InsertStatementContext)queryContext.getSqlStatementContext());
        }
        if (queryContext.getSqlStatementContext() instanceof DeleteStatementContext) {
            return new ShadowDeleteStatementDataSourceMappingsRetriever((DeleteStatementContext)queryContext.getSqlStatementContext(), queryContext.getParameters());
        }
        if (queryContext.getSqlStatementContext() instanceof UpdateStatementContext) {
            return new ShadowUpdateStatementDataSourceMappingsRetriever((UpdateStatementContext)queryContext.getSqlStatementContext(), queryContext.getParameters());
        }
        if (queryContext.getSqlStatementContext() instanceof SelectStatementContext) {
            return new ShadowSelectStatementDataSourceMappingsRetriever((SelectStatementContext)queryContext.getSqlStatementContext(), queryContext.getParameters());
        }
        return null;
    }

    @Override
    public Map<String, String> retrieve(ShadowRule rule) {
        Collection<String> shadowTables = rule.filterShadowTables(this.tableNames);
        Map<String, String> result = this.tableHintDataSourceMappingsRetriever.retrieve(rule, shadowTables);
        return result.isEmpty() && null != this.shadowColumnDataSourceMappingsRetriever ? this.shadowColumnDataSourceMappingsRetriever.retrieve(rule, shadowTables) : result;
    }
}

