/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.merge.result.impl.memory;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;

public final class MemoryQueryResultRow {
    private final Object[] data;

    public MemoryQueryResultRow(QueryResult queryResult) throws SQLException {
        this.data = this.load(queryResult);
    }

    private Object[] load(QueryResult queryResult) throws SQLException {
        int columnCount = queryResult.getMetaData().getColumnCount();
        Object[] result = new Object[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            result[i] = queryResult.getValue(i + 1, Object.class);
        }
        return result;
    }

    public Object getCell(int columnIndex) {
        Preconditions.checkArgument((columnIndex > 0 && columnIndex < this.data.length + 1 ? 1 : 0) != 0);
        return this.data[columnIndex - 1];
    }

    public void setCell(int columnIndex, Object value) {
        Preconditions.checkArgument((columnIndex > 0 && columnIndex < this.data.length + 1 ? 1 : 0) != 0);
        this.data[columnIndex - 1] = value;
    }

    @Generated
    public MemoryQueryResultRow(Object[] data) {
        this.data = data;
    }
}

