/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.extractor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.datetime.DatetimeExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CollateExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExistsSubqueryExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.NotExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.TypeCastExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.match.MatchAgainstExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;

public final class SubqueryExtractor {
    public static Collection<SubquerySegment> extractSubquerySegments(SelectStatement selectStatement, boolean needRecursive) {
        LinkedList<SubquerySegment> result = new LinkedList<SubquerySegment>();
        SubqueryType parentSubqueryType = selectStatement.getSubqueryType().orElse(null);
        SubqueryExtractor.extractSubquerySegments(result, selectStatement, needRecursive, parentSubqueryType);
        return result;
    }

    private static void extractSubquerySegments(List<SubquerySegment> result, SelectStatement selectStatement, boolean needRecursive, SubqueryType parentSubqueryType) {
        SubqueryExtractor.extractSubquerySegmentsFromProjections(result, selectStatement.getProjections(), needRecursive);
        selectStatement.getFrom().ifPresent(optional -> SubqueryExtractor.extractSubquerySegmentsFromTableSegment(result, optional, needRecursive));
        if (selectStatement.getWhere().isPresent()) {
            SubqueryExtractor.extractSubquerySegmentsFromWhere(result, selectStatement.getWhere().get().getExpr(), needRecursive);
        }
        if (selectStatement.getCombine().isPresent()) {
            SubqueryExtractor.extractSubquerySegmentsFromCombine(result, selectStatement.getCombine().get(), needRecursive, parentSubqueryType);
        }
        if (selectStatement.getWithSegment().isPresent()) {
            SubqueryExtractor.extractSubquerySegmentsFromCTEs(result, selectStatement.getWithSegment().get().getCommonTableExpressions(), needRecursive);
        }
    }

    private static void extractSubquerySegmentsFromCTEs(List<SubquerySegment> result, Collection<CommonTableExpressionSegment> withSegment, boolean needRecursive) {
        for (CommonTableExpressionSegment each : withSegment) {
            each.getSubquery().getSelect().setSubqueryType(SubqueryType.WITH);
            result.add(each.getSubquery());
            SubqueryExtractor.extractRecursive(needRecursive, result, each.getSubquery().getSelect(), SubqueryType.TABLE);
        }
    }

    private static void extractRecursive(boolean needRecursive, List<SubquerySegment> result, SelectStatement select, SubqueryType parentSubqueryType) {
        if (needRecursive) {
            SubqueryExtractor.extractSubquerySegments(result, select, true, parentSubqueryType);
        }
    }

    private static void extractSubquerySegmentsFromProjections(List<SubquerySegment> result, ProjectionsSegment projections, boolean needRecursive) {
        if (null == projections || projections.getProjections().isEmpty()) {
            return;
        }
        for (ProjectionSegment each : projections.getProjections()) {
            if (each instanceof SubqueryProjectionSegment) {
                SubquerySegment subquery = ((SubqueryProjectionSegment)each).getSubquery();
                subquery.getSelect().setSubqueryType(SubqueryType.PROJECTION);
                result.add(subquery);
                SubqueryExtractor.extractRecursive(needRecursive, result, subquery.getSelect(), SubqueryType.TABLE);
                continue;
            }
            if (!(each instanceof ExpressionProjectionSegment)) continue;
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((ExpressionProjectionSegment)each).getExpr(), SubqueryType.PROJECTION, needRecursive);
        }
    }

    private static void extractSubquerySegmentsFromTableSegment(List<SubquerySegment> result, TableSegment tableSegment, boolean needRecursive) {
        if (tableSegment instanceof SubqueryTableSegment) {
            SubqueryExtractor.extractSubquerySegmentsFromSubqueryTableSegment(result, (SubqueryTableSegment)tableSegment, needRecursive);
        }
        if (tableSegment instanceof JoinTableSegment) {
            SubqueryExtractor.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getLeft(), needRecursive);
            SubqueryExtractor.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getRight(), needRecursive);
        }
    }

    private static void extractSubquerySegmentsFromJoinTableSegment(List<SubquerySegment> result, TableSegment tableSegment, boolean needRecursive) {
        if (tableSegment instanceof SubqueryTableSegment) {
            SubquerySegment subquery = ((SubqueryTableSegment)tableSegment).getSubquery();
            subquery.getSelect().setSubqueryType(SubqueryType.JOIN);
            result.add(subquery);
            SubqueryExtractor.extractRecursive(needRecursive, result, subquery.getSelect(), SubqueryType.TABLE);
        } else if (tableSegment instanceof JoinTableSegment) {
            SubqueryExtractor.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getLeft(), needRecursive);
            SubqueryExtractor.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getRight(), needRecursive);
        }
    }

    private static void extractSubquerySegmentsFromSubqueryTableSegment(List<SubquerySegment> result, SubqueryTableSegment subqueryTableSegment, boolean needRecursive) {
        SubquerySegment subquery = subqueryTableSegment.getSubquery();
        subquery.getSelect().setSubqueryType(SubqueryType.TABLE);
        result.add(subquery);
        SubqueryExtractor.extractRecursive(needRecursive, result, subquery.getSelect(), SubqueryType.TABLE);
    }

    private static void extractSubquerySegmentsFromWhere(List<SubquerySegment> result, ExpressionSegment expressionSegment, boolean needRecursive) {
        SubqueryExtractor.extractSubquerySegmentsFromExpression(result, expressionSegment, SubqueryType.PREDICATE, needRecursive);
    }

    private static void extractSubquerySegmentsFromExpression(List<SubquerySegment> result, ExpressionSegment expressionSegment, SubqueryType subqueryType, boolean needRecursive) {
        SubquerySegment subquery;
        if (expressionSegment instanceof SubqueryExpressionSegment) {
            subquery = ((SubqueryExpressionSegment)expressionSegment).getSubquery();
            subquery.getSelect().setSubqueryType(subqueryType);
            result.add(subquery);
            SubqueryExtractor.extractRecursive(needRecursive, result, subquery.getSelect(), SubqueryType.TABLE);
        }
        if (expressionSegment instanceof ExistsSubqueryExpression) {
            subquery = ((ExistsSubqueryExpression)expressionSegment).getSubquery();
            subquery.getSelect().setSubqueryType(subqueryType);
            result.add(subquery);
            SubqueryExtractor.extractRecursive(needRecursive, result, subquery.getSelect(), SubqueryType.TABLE);
        }
        if (expressionSegment instanceof ListExpression) {
            ((ListExpression)expressionSegment).getItems().forEach(each -> SubqueryExtractor.extractSubquerySegmentsFromExpression(result, each, subqueryType, needRecursive));
        }
        if (expressionSegment instanceof BinaryOperationExpression) {
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((BinaryOperationExpression)expressionSegment).getLeft(), subqueryType, needRecursive);
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((BinaryOperationExpression)expressionSegment).getRight(), subqueryType, needRecursive);
        }
        if (expressionSegment instanceof InExpression) {
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((InExpression)expressionSegment).getLeft(), subqueryType, needRecursive);
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((InExpression)expressionSegment).getRight(), subqueryType, needRecursive);
        }
        if (expressionSegment instanceof BetweenExpression) {
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((BetweenExpression)expressionSegment).getBetweenExpr(), subqueryType, needRecursive);
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((BetweenExpression)expressionSegment).getAndExpr(), subqueryType, needRecursive);
        }
        if (expressionSegment instanceof NotExpression) {
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((NotExpression)expressionSegment).getExpression(), subqueryType, needRecursive);
        }
        if (expressionSegment instanceof FunctionSegment) {
            ((FunctionSegment)expressionSegment).getParameters().forEach(each -> SubqueryExtractor.extractSubquerySegmentsFromExpression(result, each, subqueryType, needRecursive));
        }
        if (expressionSegment instanceof MatchAgainstExpression) {
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((MatchAgainstExpression)expressionSegment).getExpr(), subqueryType, needRecursive);
        }
        if (expressionSegment instanceof CaseWhenExpression) {
            SubqueryExtractor.extractSubquerySegmentsFromCaseWhenExpression(result, (CaseWhenExpression)expressionSegment, subqueryType, needRecursive);
        }
        if (expressionSegment instanceof CollateExpression) {
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((CollateExpression)expressionSegment).getCollateName(), subqueryType, needRecursive);
        }
        if (expressionSegment instanceof DatetimeExpression) {
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((DatetimeExpression)expressionSegment).getLeft(), subqueryType, needRecursive);
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((DatetimeExpression)expressionSegment).getRight(), subqueryType, needRecursive);
        }
        if (expressionSegment instanceof NotExpression) {
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((NotExpression)expressionSegment).getExpression(), subqueryType, needRecursive);
        }
        if (expressionSegment instanceof TypeCastExpression) {
            SubqueryExtractor.extractSubquerySegmentsFromExpression(result, ((TypeCastExpression)expressionSegment).getExpression(), subqueryType, needRecursive);
        }
    }

    private static void extractSubquerySegmentsFromCaseWhenExpression(List<SubquerySegment> result, CaseWhenExpression expressionSegment, SubqueryType subqueryType, boolean needRecursive) {
        SubqueryExtractor.extractSubquerySegmentsFromExpression(result, expressionSegment.getCaseExpr(), subqueryType, needRecursive);
        expressionSegment.getWhenExprs().forEach(each -> SubqueryExtractor.extractSubquerySegmentsFromExpression(result, each, subqueryType, needRecursive));
        expressionSegment.getThenExprs().forEach(each -> SubqueryExtractor.extractSubquerySegmentsFromExpression(result, each, subqueryType, needRecursive));
        SubqueryExtractor.extractSubquerySegmentsFromExpression(result, expressionSegment.getElseExpr(), subqueryType, needRecursive);
    }

    private static void extractSubquerySegmentsFromCombine(List<SubquerySegment> result, CombineSegment combineSegment, boolean needRecursive, SubqueryType parentSubqueryType) {
        combineSegment.getLeft().getSelect().setSubqueryType(parentSubqueryType);
        combineSegment.getRight().getSelect().setSubqueryType(parentSubqueryType);
        result.add(combineSegment.getLeft());
        result.add(combineSegment.getRight());
        SubqueryExtractor.extractRecursive(needRecursive, result, combineSegment.getLeft().getSelect(), parentSubqueryType);
        SubqueryExtractor.extractRecursive(needRecursive, result, combineSegment.getRight().getSelect(), parentSubqueryType);
    }

    @Generated
    private SubqueryExtractor() {
    }
}

