/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.opengauss.codec.OpenGaussPacketCodecEngine;
import org.apache.shardingsphere.infra.exception.dialect.exception.transaction.InTransactionException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.opengauss.authentication.OpenGaussAuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.opengauss.command.OpenGaussCommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.postgresql.PostgreSQLFrontendEngine;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;

public final class OpenGaussFrontendEngine
implements DatabaseProtocolFrontendEngine {
    private final PostgreSQLFrontendEngine postgresqlFrontendEngine = new PostgreSQLFrontendEngine();
    private final OpenGaussAuthenticationEngine authenticationEngine = new OpenGaussAuthenticationEngine();
    private final OpenGaussCommandExecuteEngine commandExecuteEngine = new OpenGaussCommandExecuteEngine();
    private final OpenGaussPacketCodecEngine codecEngine = new OpenGaussPacketCodecEngine();

    public void release(ConnectionSession connectionSession) {
        this.postgresqlFrontendEngine.release(connectionSession);
    }

    public void handleException(ConnectionSession connectionSession, Exception exception) {
        if (connectionSession.getTransactionStatus().isInTransaction() && !connectionSession.getConnectionContext().getTransactionContext().isExceptionOccur() && !(exception instanceof InTransactionException)) {
            connectionSession.getConnectionContext().getTransactionContext().setExceptionOccur(true);
        }
    }

    public String getDatabaseType() {
        return "openGauss";
    }

    @Generated
    public OpenGaussAuthenticationEngine getAuthenticationEngine() {
        return this.authenticationEngine;
    }

    @Generated
    public OpenGaussCommandExecuteEngine getCommandExecuteEngine() {
        return this.commandExecuteEngine;
    }

    @Generated
    public OpenGaussPacketCodecEngine getCodecEngine() {
        return this.codecEngine;
    }
}

