/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.importer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shardingsphere.data.pipeline.cdc.core.ack.CDCAckId;
import org.apache.shardingsphere.data.pipeline.cdc.core.ack.CDCAckPosition;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.CDCChannelProgressPair;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.CDCImporterManager;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.CSNRecords;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.CSNRecordsComparator;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.execute.AbstractPipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.importer.Importer;
import org.apache.shardingsphere.data.pipeline.core.importer.sink.PipelineSink;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.FinishedRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobUpdateProgress;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDCImporter
extends AbstractPipelineLifecycleRunnable
implements Importer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CDCImporter.class);
    private final String importerId = RandomStringUtils.randomAlphanumeric((int)8);
    private final List<CDCChannelProgressPair> channelProgressPairs;
    private final int batchSize;
    private final long timeoutMillis;
    private final PipelineSink sink;
    private final boolean needSorting;
    private final JobRateLimitAlgorithm rateLimitAlgorithm;
    private final PriorityQueue<CSNRecords> csnRecordsQueue = new PriorityQueue<CSNRecords>(new CSNRecordsComparator());
    private final Cache<String, List<Pair<CDCChannelProgressPair, CDCAckPosition>>> ackCache = Caffeine.newBuilder().maximumSize(10000L).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    protected void runBlocking() {
        CDCImporterManager.putImporter(this);
        for (CDCChannelProgressPair each : this.channelProgressPairs) {
            each.getJobProgressListener().onProgressUpdated(new PipelineJobUpdateProgress(0));
        }
        while (this.isRunning()) {
            if (this.needSorting) {
                this.doWithSorting();
            } else {
                this.doWithoutSorting();
            }
            if (!this.channelProgressPairs.isEmpty()) continue;
            break;
        }
    }

    private void doWithSorting() {
        List<CSNRecords> csnRecordsList;
        if (null != this.rateLimitAlgorithm) {
            this.rateLimitAlgorithm.intercept(PipelineSQLOperationType.INSERT, (Number)1);
        }
        if ((csnRecordsList = this.getCsnRecordsList()).isEmpty()) {
            TimeUnit.MILLISECONDS.sleep(this.timeoutMillis);
            return;
        }
        String ackId = CDCAckId.build(this.importerId).marshal();
        if (1 == csnRecordsList.size()) {
            this.processCSNRecords(csnRecordsList.get(0), ackId);
        } else {
            this.processCSNRecordsList(csnRecordsList, ackId);
        }
    }

    private List<CSNRecords> getCsnRecordsList() {
        LinkedList<CSNRecords> result = new LinkedList<CSNRecords>();
        CSNRecords firstRecords = null;
        int count = this.channelProgressPairs.size();
        for (int i = 0; i < count; ++i) {
            this.prepareTransactionRecords();
            CSNRecords csnRecords = this.csnRecordsQueue.peek();
            if (null == csnRecords) continue;
            if (null == firstRecords) {
                firstRecords = csnRecords = this.csnRecordsQueue.poll();
                result.add(csnRecords);
                continue;
            }
            if (csnRecords.getCsn() != firstRecords.getCsn()) continue;
            csnRecords = this.csnRecordsQueue.poll();
            result.add(csnRecords);
        }
        return result;
    }

    private void prepareTransactionRecords() {
        if (this.csnRecordsQueue.isEmpty()) {
            this.prepareWhenQueueIsEmpty();
        } else {
            this.prepareWhenQueueIsNotEmpty(this.csnRecordsQueue.peek().getCsn());
        }
    }

    private void prepareWhenQueueIsEmpty() {
        for (CDCChannelProgressPair each : this.channelProgressPairs) {
            PipelineChannel channel = each.getChannel();
            List records = channel.poll();
            if (records.isEmpty()) continue;
            if (0 == this.getDataRecordsCount(records)) {
                channel.ack(records);
                continue;
            }
            this.csnRecordsQueue.add(new CSNRecords(this.findFirstDataRecord(records).getCsn(), each, records));
        }
    }

    private void prepareWhenQueueIsNotEmpty(long oldestCSN) {
        for (CDCChannelProgressPair each : this.channelProgressPairs) {
            PipelineChannel channel = each.getChannel();
            List records = channel.peek();
            if (records.isEmpty()) continue;
            if (0 == this.getDataRecordsCount(records)) {
                records = channel.poll();
                channel.ack(records);
                continue;
            }
            long csn = this.findFirstDataRecord(records).getCsn();
            if (csn > oldestCSN) continue;
            records = channel.poll();
            this.csnRecordsQueue.add(new CSNRecords(csn, each, records));
        }
    }

    private int getDataRecordsCount(List<Record> records) {
        return (int)records.stream().filter(DataRecord.class::isInstance).count();
    }

    private DataRecord findFirstDataRecord(List<Record> records) {
        for (Record each : records) {
            if (!(each instanceof DataRecord)) continue;
            return (DataRecord)each;
        }
        throw new IllegalStateException("No data record found");
    }

    private void processCSNRecords(CSNRecords csnRecords, String ackId) {
        List<Record> records = csnRecords.getRecords();
        this.ackCache.put((Object)ackId, Collections.singletonList(Pair.of((Object)csnRecords.getChannelProgressPair(), (Object)new CDCAckPosition(records.get(records.size() - 1), this.getDataRecordsCount(records)))));
        this.sink.write(ackId, this.filterDataRecords(records));
    }

    private void processCSNRecordsList(List<CSNRecords> csnRecordsList, String ackId) {
        List ackValue = csnRecordsList.stream().map(each -> Pair.of((Object)each.getChannelProgressPair(), (Object)new CDCAckPosition(each.getRecords().get(each.getRecords().size() - 1), this.getDataRecordsCount(each.getRecords())))).collect(Collectors.toList());
        this.ackCache.put((Object)ackId, ackValue);
        ArrayList<Record> records = new ArrayList<Record>(ackValue.stream().mapToInt(each -> ((CDCAckPosition)each.getRight()).getDataRecordCount()).sum());
        csnRecordsList.forEach(each -> records.addAll(this.filterDataRecords(each.getRecords())));
        this.sink.write(ackId, this.filterDataRecords(records));
    }

    private List<Record> filterDataRecords(Collection<Record> records) {
        return records.stream().filter(DataRecord.class::isInstance).map(DataRecord.class::cast).collect(Collectors.toList());
    }

    private void doWithoutSorting() {
        for (CDCChannelProgressPair each : this.channelProgressPairs) {
            this.doWithoutSorting(each);
        }
    }

    private void doWithoutSorting(CDCChannelProgressPair channelProgressPair) {
        PipelineChannel channel = channelProgressPair.getChannel();
        List records = channel.fetch(this.batchSize, this.timeoutMillis);
        if (records.isEmpty()) {
            return;
        }
        Record lastRecord = (Record)records.get(records.size() - 1);
        if (records.stream().noneMatch(DataRecord.class::isInstance)) {
            channel.ack(records);
            channelProgressPair.getJobProgressListener().onProgressUpdated(new PipelineJobUpdateProgress(0));
            if (lastRecord instanceof FinishedRecord) {
                this.channelProgressPairs.remove(channelProgressPair);
            }
            return;
        }
        if (null != this.rateLimitAlgorithm) {
            this.rateLimitAlgorithm.intercept(PipelineSQLOperationType.INSERT, (Number)1);
        }
        String ackId = CDCAckId.build(this.importerId).marshal();
        this.ackCache.put((Object)ackId, Collections.singletonList(Pair.of((Object)channelProgressPair, (Object)new CDCAckPosition((Record)records.get(records.size() - 1), this.getDataRecordsCount(records)))));
        this.sink.write(ackId, (Collection)records);
    }

    public void ack(String ackId) {
        List channelPositionPairList = (List)this.ackCache.getIfPresent((Object)ackId);
        if (null == channelPositionPairList) {
            log.warn("Could not find cached ack info, ack id: {}", (Object)ackId);
            return;
        }
        for (Pair each : channelPositionPairList) {
            CDCAckPosition ackPosition = (CDCAckPosition)each.getRight();
            Record lastRecord = ackPosition.getLastRecord();
            ((CDCChannelProgressPair)each.getLeft()).getChannel().ack(Collections.singletonList(lastRecord));
            if (lastRecord instanceof FinishedRecord) {
                this.channelProgressPairs.remove(each.getKey());
            }
            ((CDCChannelProgressPair)each.getLeft()).getJobProgressListener().onProgressUpdated(new PipelineJobUpdateProgress(ackPosition.getDataRecordCount()));
        }
        this.ackCache.invalidate((Object)ackId);
    }

    protected void doStop() {
        CDCImporterManager.removeImporter(this.importerId);
    }

    @Generated
    public CDCImporter(List<CDCChannelProgressPair> channelProgressPairs, int batchSize, long timeoutMillis, PipelineSink sink, boolean needSorting, JobRateLimitAlgorithm rateLimitAlgorithm) {
        this.channelProgressPairs = channelProgressPairs;
        this.batchSize = batchSize;
        this.timeoutMillis = timeoutMillis;
        this.sink = sink;
        this.needSorting = needSorting;
        this.rateLimitAlgorithm = rateLimitAlgorithm;
    }

    @Generated
    public String getImporterId() {
        return this.importerId;
    }
}

