/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.text.fieldlist;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinition41Packet;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.fieldlist.MySQLComFieldListPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnector;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnectorFactory;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.ServerStatusFlagCalculator;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class MySQLComFieldListPacketExecutor
implements CommandExecutor {
    private static final String SQL = "SHOW COLUMNS FROM %s FROM %s";
    private final MySQLComFieldListPacket packet;
    private final ConnectionSession connectionSession;
    private DatabaseConnector databaseConnector;

    public Collection<DatabasePacket> execute() throws SQLException {
        String currentDatabaseName = this.connectionSession.getCurrentDatabaseName();
        String sql = String.format(SQL, this.packet.getTable(), currentDatabaseName);
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        SQLParserRule sqlParserRule = (SQLParserRule)metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        SQLStatement sqlStatement = sqlParserRule.getSQLParserEngine((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL")).parse(sql, false);
        HintValueContext hintValueContext = SQLHintUtils.extractHint((String)sql);
        SQLStatementContext sqlStatementContext = new SQLBindEngine(metaDataContexts.getMetaData(), currentDatabaseName, hintValueContext).bind(sqlStatement, Collections.emptyList());
        ProxyDatabaseConnectionManager databaseConnectionManager = this.connectionSession.getDatabaseConnectionManager();
        QueryContext queryContext = new QueryContext(sqlStatementContext, sql, Collections.emptyList(), hintValueContext, this.connectionSession.getConnectionContext(), metaDataContexts.getMetaData());
        this.databaseConnector = DatabaseConnectorFactory.getInstance().newInstance(queryContext, databaseConnectionManager, false);
        this.databaseConnector.execute();
        return this.createColumnDefinition41Packets(currentDatabaseName);
    }

    private Collection<DatabasePacket> createColumnDefinition41Packets(String databaseName) throws SQLException {
        LinkedList<DatabasePacket> result = new LinkedList<DatabasePacket>();
        int characterSet = ((MySQLCharacterSet)this.connectionSession.getAttributeMap().attr(MySQLConstants.CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
        while (this.databaseConnector.next()) {
            String columnName = ((QueryResponseCell)this.databaseConnector.getRowData().getCells().iterator().next()).getData().toString();
            result.add((DatabasePacket)new MySQLColumnDefinition41Packet(characterSet, databaseName, this.packet.getTable(), this.packet.getTable(), columnName, columnName, 100, MySQLBinaryColumnType.VARCHAR, 0, true));
        }
        result.add((DatabasePacket)new MySQLEofPacket(ServerStatusFlagCalculator.calculateFor(this.connectionSession, true)));
        return result;
    }

    public void close() throws SQLException {
        if (null != this.databaseConnector) {
            this.databaseConnector.close();
        }
    }

    @Generated
    public MySQLComFieldListPacketExecutor(MySQLComFieldListPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

