/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.expression.DerivedLiteralExpressionSegment;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.expression.DerivedParameterMarkerExpressionSegment;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.InsertValue;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.InsertValuesToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;

public final class GeneratedKeyInsertValuesTokenGenerator
extends BaseGeneratedKeyTokenGenerator
implements PreviousSQLTokensAware {
    private List<SQLToken> previousSQLTokens;

    @Override
    protected boolean isGenerateSQLToken(InsertStatementContext insertStatementContext) {
        return !insertStatementContext.getSqlStatement().getValues().isEmpty() && insertStatementContext.getGeneratedKeyContext().isPresent() && !((GeneratedKeyContext)insertStatementContext.getGeneratedKeyContext().get()).getGeneratedValues().isEmpty();
    }

    @Override
    public SQLToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional<InsertValuesToken> result = this.findPreviousSQLToken();
        Preconditions.checkState((boolean)result.isPresent());
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        Preconditions.checkState((boolean)generatedKey.isPresent());
        Iterator generatedValues = ((GeneratedKeyContext)generatedKey.get()).getGeneratedValues().iterator();
        int count = 0;
        List params = insertStatementContext.getGroupedParameters();
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            InsertValue insertValueToken = result.get().getInsertValues().get(count);
            DerivedLiteralExpressionSegment expressionSegment = this.isToAddDerivedLiteralExpression(params, count) ? new DerivedLiteralExpressionSegment(generatedValues.next()) : new DerivedParameterMarkerExpressionSegment(each.getParameterCount());
            insertValueToken.getValues().add((ExpressionSegment)expressionSegment);
            ++count;
        }
        return result.get();
    }

    private Optional<InsertValuesToken> findPreviousSQLToken() {
        for (SQLToken each : this.previousSQLTokens) {
            if (!(each instanceof InsertValuesToken)) continue;
            return Optional.of((InsertValuesToken)each);
        }
        return Optional.empty();
    }

    private boolean isToAddDerivedLiteralExpression(List<List<Object>> params, int insertValueCount) {
        return params.get(insertValueCount).isEmpty();
    }

    @Override
    @Generated
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }
}

