/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database;

import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.DatabaseRuleOperatorFactory;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDefinitionExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorRequiredChecker;
import org.apache.shardingsphere.distsql.statement.rdl.rule.database.DatabaseRuleDefinitionStatement;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class DatabaseRuleDefinitionExecuteEngine {
    private final DatabaseRuleDefinitionStatement sqlStatement;
    private final ContextManager contextManager;
    private final String databaseName;
    private final DatabaseRuleDefinitionExecutor executor;

    public void executeUpdate() throws SQLException {
        this.executor.setDatabase(this.contextManager.getDatabase(this.databaseName));
        Optional rule = this.contextManager.getDatabase(this.databaseName).getRuleMetaData().findSingleRule(this.executor.getRuleClass());
        this.executor.setRule(rule.orElse(null));
        this.checkBeforeUpdate();
        RuleConfiguration currentRuleConfig = rule.map(ShardingSphereRule::getConfiguration).orElse(null);
        if (this.getRefreshStatus(rule.isPresent())) {
            DatabaseRuleOperatorFactory.newInstance(this.contextManager, this.executor).operate(this.sqlStatement, this.contextManager.getDatabase(this.databaseName), currentRuleConfig);
        }
    }

    private void checkBeforeUpdate() {
        new DistSQLExecutorRequiredChecker(this.executor).check((SQLStatement)this.sqlStatement, this.contextManager, this.contextManager.getDatabase(this.databaseName));
        this.executor.checkBeforeUpdate(this.sqlStatement);
    }

    private boolean getRefreshStatus(boolean currentRuleExists) {
        return !(this.executor instanceof DatabaseRuleDropExecutor) || currentRuleExists && ((DatabaseRuleDropExecutor)this.executor).hasAnyOneToBeDropped(this.sqlStatement);
    }

    @Generated
    public DatabaseRuleDefinitionExecuteEngine(DatabaseRuleDefinitionStatement sqlStatement, ContextManager contextManager, String databaseName, DatabaseRuleDefinitionExecutor executor) {
        this.sqlStatement = sqlStatement;
        this.contextManager = contextManager;
        this.databaseName = databaseName;
        this.executor = executor;
    }
}

