/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.globalclock.executor;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.globalclock.executor.GlobalClockLock;
import org.apache.shardingsphere.globalclock.executor.GlobalClockTransactionExecutor;
import org.apache.shardingsphere.globalclock.provider.GlobalClockProvider;
import org.apache.shardingsphere.globalclock.rule.GlobalClockRule;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.lock.LockDefinition;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.mode.lock.global.GlobalLock;
import org.apache.shardingsphere.mode.lock.global.GlobalLockDefinition;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.transaction.spi.TransactionHook;

public final class GlobalClockTransactionHook
implements TransactionHook<GlobalClockRule> {
    private final LockDefinition lockDefinition = new GlobalLockDefinition((GlobalLock)new GlobalClockLock());

    public void beforeBegin(GlobalClockRule rule, DatabaseType databaseType, TransactionConnectionContext transactionContext) {
    }

    public void afterBegin(GlobalClockRule rule, DatabaseType databaseType, TransactionConnectionContext transactionContext) {
        rule.getGlobalClockProvider().ifPresent(optional -> transactionContext.setBeginMills(optional.getCurrentTimestamp()));
    }

    public void afterCreateConnections(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext transactionContext) throws SQLException {
        if (!rule.getConfiguration().isEnabled()) {
            return;
        }
        Optional globalClockTransactionExecutor = DatabaseTypedSPILoader.findService(GlobalClockTransactionExecutor.class, (DatabaseType)databaseType);
        if (globalClockTransactionExecutor.isPresent()) {
            ((GlobalClockTransactionExecutor)globalClockTransactionExecutor.get()).sendSnapshotTimestamp(connections, transactionContext.getBeginMills());
        }
    }

    public void beforeExecuteSQL(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext connectionContext, TransactionIsolationLevel isolationLevel) throws SQLException {
        if (!rule.getConfiguration().isEnabled() || null != isolationLevel && TransactionIsolationLevel.READ_COMMITTED != isolationLevel) {
            return;
        }
        Optional globalClockTransactionExecutor = DatabaseTypedSPILoader.findService(GlobalClockTransactionExecutor.class, (DatabaseType)databaseType);
        if (!globalClockTransactionExecutor.isPresent()) {
            return;
        }
        Optional<GlobalClockProvider> globalClockProvider = rule.getGlobalClockProvider();
        Preconditions.checkState((boolean)globalClockProvider.isPresent());
        ((GlobalClockTransactionExecutor)globalClockTransactionExecutor.get()).sendSnapshotTimestamp(connections, globalClockProvider.get().getCurrentTimestamp());
    }

    public void beforeCommit(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext transactionContext, LockContext lockContext) throws SQLException {
        if (!rule.getConfiguration().isEnabled()) {
            return;
        }
        if (lockContext.tryLock(this.lockDefinition, 200L)) {
            Optional globalClockTransactionExecutor = DatabaseTypedSPILoader.findService(GlobalClockTransactionExecutor.class, (DatabaseType)databaseType);
            if (!globalClockTransactionExecutor.isPresent()) {
                return;
            }
            Optional<GlobalClockProvider> globalClockProvider = rule.getGlobalClockProvider();
            Preconditions.checkState((boolean)globalClockProvider.isPresent());
            ((GlobalClockTransactionExecutor)globalClockTransactionExecutor.get()).sendCommitTimestamp(connections, globalClockProvider.get().getCurrentTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext transactionContext, LockContext lockContext) {
        Optional<GlobalClockProvider> globalClockProvider = rule.getGlobalClockProvider();
        if (!globalClockProvider.isPresent()) {
            return;
        }
        try {
            globalClockProvider.get().getNextTimestamp();
        }
        finally {
            lockContext.unlock(this.lockDefinition);
        }
    }

    public void beforeRollback(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext transactionContext) {
    }

    public void afterRollback(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext transactionContext) {
    }

    public int getOrder() {
        return 1300;
    }

    public Class<GlobalClockRule> getTypeClass() {
        return GlobalClockRule.class;
    }
}

