/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.AutoScaleRule;
import com.netflix.fenzo.AutoScaleRules;
import com.netflix.fenzo.BaseShortfallEvaluator;
import com.netflix.fenzo.TaskRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class NaiveShortfallEvaluator
extends BaseShortfallEvaluator {
    NaiveShortfallEvaluator() {
    }

    @Override
    public Map<String, Integer> getShortfall(Set<String> vmGroupNames, Set<TaskRequest> failures, AutoScaleRules autoScaleRules) {
        if (vmGroupNames != null && failures != null && !failures.isEmpty()) {
            this.reset();
            return this.adjustAgentScaleUp(this.fillShortfallMap(vmGroupNames, this.filterFailedTasks(failures)), autoScaleRules);
        }
        return Collections.emptyMap();
    }

    private Map<String, Integer> adjustAgentScaleUp(Map<String, Integer> shortfallMap, AutoScaleRules autoScaleRules) {
        HashMap<String, Integer> corrected = new HashMap<String, Integer>(shortfallMap);
        for (Map.Entry<String, Integer> entry : shortfallMap.entrySet()) {
            int adjustedValue;
            AutoScaleRule rule = autoScaleRules.get(entry.getKey());
            if (rule == null || (adjustedValue = rule.getShortfallAdjustedAgents(entry.getValue())) <= 0) continue;
            corrected.put(entry.getKey(), adjustedValue);
        }
        return corrected;
    }
}

