/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.client;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.common.StringUtils;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.util.ConfigUtils;

public final class ConnectStringParser {
    private static final int DEFAULT_PORT = 2181;
    private final String chrootPath;
    private final ArrayList<InetSocketAddress> serverAddresses = new ArrayList();

    public ConnectStringParser(String connectString) {
        int off = connectString.indexOf(47);
        if (off >= 0) {
            String chrootPath = connectString.substring(off);
            if (chrootPath.length() == 1) {
                this.chrootPath = null;
            } else {
                PathUtils.validatePath(chrootPath);
                this.chrootPath = chrootPath;
            }
            connectString = connectString.substring(0, off);
        } else {
            this.chrootPath = null;
        }
        List<String> hostsList = StringUtils.split(connectString, ",");
        for (String host : hostsList) {
            int port = 2181;
            try {
                String[] hostAndPort = ConfigUtils.getHostAndPort(host);
                host = hostAndPort[0];
                if (hostAndPort.length == 2) {
                    port = Integer.parseInt(hostAndPort[1]);
                }
            }
            catch (QuorumPeerConfig.ConfigException e) {
                e.printStackTrace();
            }
            this.serverAddresses.add(InetSocketAddress.createUnresolved(host, port));
        }
    }

    public String getChrootPath() {
        return this.chrootPath;
    }

    public ArrayList<InetSocketAddress> getServerAddresses() {
        return this.serverAddresses;
    }
}

