/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisParamAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeParamAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisParamAnnos;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.util.ByteSequence;

public abstract class Utility {
    private static boolean wide = false;

    public static final String accessToString(int n) {
        return Utility.accessToString(n, false);
    }

    public static final String accessToString(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while (n2 < 2048) {
            n2 = Utility.pow2(n3);
            if ((n & n2) != 0 && (!bl || n2 != 32 && n2 != 512)) {
                stringBuffer.append(Constants.ACCESS_NAMES[n3]).append(" ");
            }
            ++n3;
        }
        return stringBuffer.toString().trim();
    }

    public static final String classOrInterface(int n) {
        return (n & 0x200) != 0 ? "interface" : "class";
    }

    public static final String codeToString(byte[] byArray, ConstantPool constantPool, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 20);
        ByteSequence byteSequence = new ByteSequence(byArray);
        try {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                Utility.codeToString(byteSequence, constantPool, bl);
            }
            n3 = 0;
            while (byteSequence.available() > 0) {
                if (n2 < 0 || n3 < n2) {
                    String string = Utility.fillup(byteSequence.getIndex() + ":", 6, true, ' ');
                    stringBuffer.append(string + Utility.codeToString(byteSequence, constantPool, bl) + '\n');
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            System.out.println(stringBuffer.toString());
            iOException.printStackTrace();
            throw new ClassFormatException("Byte code error: " + iOException);
        }
        return stringBuffer.toString();
    }

    public static final String codeToString(byte[] byArray, ConstantPool constantPool, int n, int n2) {
        return Utility.codeToString(byArray, constantPool, n, n2, true);
    }

    public static final String codeToString(ByteSequence byteSequence, ConstantPool constantPool) throws IOException {
        return Utility.codeToString(byteSequence, constantPool, true);
    }

    public static final String compactClassName(String string) {
        return Utility.compactClassName(string, true);
    }

    public static final String compactClassName(String string, String string2, boolean bl) {
        string = string.replace('/', '.');
        if (bl) {
            String string3;
            int n = string2.length();
            if (string.startsWith(string2) && (string3 = string.substring(n)).indexOf(46) == -1) {
                string = string3;
            }
        }
        return string;
    }

    public static final String compactClassName(String string, boolean bl) {
        return Utility.compactClassName(string, "java.lang.", bl);
    }

    public static final String methodSignatureToString(String string, String string2, String string3) {
        return Utility.methodSignatureToString(string, string2, string3, true);
    }

    public static final String methodSignatureToString(String string, String string2, String string3, boolean bl) {
        return Utility.methodSignatureToString(string, string2, string3, bl, null);
    }

    public static final String methodSignatureToString(String string, String string2, String string3, boolean bl, LocalVariableTable localVariableTable) throws ClassFormatException {
        String string4;
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = string3.indexOf("static") >= 0 ? 0 : 1;
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            int n2 = 1;
            while (string.charAt(n2) != ')') {
                ResultHolder resultHolder = Utility.signatureToStringInternal(string.substring(n2), bl);
                String string5 = resultHolder.getResult();
                stringBuffer.append(string5);
                if (localVariableTable != null) {
                    LocalVariable localVariable = localVariableTable.getLocalVariable(n);
                    if (localVariable != null) {
                        stringBuffer.append(" " + localVariable.getName());
                    }
                } else {
                    stringBuffer.append(" arg" + n);
                }
                n = "double".equals(string5) || "long".equals(string5) ? (n += 2) : ++n;
                stringBuffer.append(", ");
                n2 += resultHolder.getConsumedChars();
            }
            string4 = Utility.signatureToString(string.substring(++n2), bl);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
        if (stringBuffer.length() > 1) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        stringBuffer.append(")");
        return string3 + (string3.length() > 0 ? " " : "") + string4 + " " + string2 + stringBuffer.toString();
    }

    public static final String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = string.indexOf(string2);
            if (n != -1) {
                int n2 = 0;
                while ((n = string.indexOf(string2, n2)) != -1) {
                    stringBuffer.append(string.substring(n2, n));
                    stringBuffer.append(string3);
                    n2 = n + string2.length();
                }
                stringBuffer.append(string.substring(n2));
                string = stringBuffer.toString();
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println(stringIndexOutOfBoundsException);
        }
        return string;
    }

    public static final String signatureToString(String string) {
        return Utility.signatureToString(string, true);
    }

    public static final String signatureToString(String string, boolean bl) {
        ResultHolder resultHolder = Utility.signatureToStringInternal(string, bl);
        return resultHolder.getResult();
    }

    public static final ResultHolder signatureToStringInternal(String string, boolean bl) {
        int n = 1;
        try {
            switch (string.charAt(0)) {
                case 'B': {
                    return ResultHolder.BYTE;
                }
                case 'C': {
                    return ResultHolder.CHAR;
                }
                case 'D': {
                    return ResultHolder.DOUBLE;
                }
                case 'F': {
                    return ResultHolder.FLOAT;
                }
                case 'I': {
                    return ResultHolder.INT;
                }
                case 'J': {
                    return ResultHolder.LONG;
                }
                case 'L': {
                    int n2;
                    int n3 = string.indexOf(59);
                    if (n3 < 0) {
                        throw new ClassFormatException("Invalid signature: " + string);
                    }
                    if (string.length() > n3 + 1 && string.charAt(n3 + 1) == '>') {
                        n3 += 2;
                    }
                    if ((n2 = string.indexOf(60)) != -1) {
                        int n4 = string.indexOf(62);
                        ResultHolder resultHolder = Utility.signatureToStringInternal(string.substring(n2 + 1, n4), bl);
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(string.substring(1, n2));
                        stringBuffer.append("<").append(resultHolder.getResult()).append(">");
                        ResultHolder resultHolder2 = new ResultHolder(Utility.compactClassName(stringBuffer.toString(), bl), n4 + 1);
                        return resultHolder2;
                    }
                    n = n3 + 1;
                    ResultHolder resultHolder = new ResultHolder(Utility.compactClassName(string.substring(1, n3), bl), n);
                    return resultHolder;
                }
                case 'S': {
                    return ResultHolder.SHORT;
                }
                case 'Z': {
                    return ResultHolder.BOOLEAN;
                }
                case '[': {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n5 = 0;
                    while (string.charAt(n5) == '[') {
                        stringBuffer.append("[]");
                        ++n5;
                    }
                    int n6 = n5;
                    ResultHolder resultHolder = Utility.signatureToStringInternal(string.substring(n5), bl);
                    stringBuffer.insert(0, resultHolder.getResult());
                    return new ResultHolder(stringBuffer.toString(), n6 += resultHolder.getConsumedChars());
                }
                case 'V': {
                    return ResultHolder.VOID;
                }
            }
            throw new ClassFormatException("Invalid signature: `" + string + "'");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid signature: " + stringIndexOutOfBoundsException + ":" + string);
        }
    }

    public static final byte typeOfMethodSignature(String string) throws ClassFormatException {
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            int n = string.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(string.substring(n));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
    }

    private static final short byteToShort(byte by) {
        return by < 0 ? (short)(256 + by) : (short)by;
    }

    public static final String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            short s = Utility.byteToShort(byArray[i]);
            String string = Integer.toString(s, 16);
            if (s < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            if (i >= byArray.length - 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static final String format(int n, int n2, boolean bl, char c) {
        return Utility.fillup(Integer.toString(n), n2, bl, c);
    }

    public static final String fillup(String string, int n, boolean bl, char c) {
        int n2 = n - string.length();
        char[] cArray = new char[n2 < 0 ? 0 : n2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = c;
        }
        if (bl) {
            return string + new String(cArray);
        }
        return new String(cArray) + string;
    }

    public static final String convertString(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block7;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block7;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Collection<RuntimeAnnos> getAnnotationAttributes(ConstantPool constantPool, List<AnnotationGen> list) {
        if (list.size() == 0) {
            return null;
        }
        try {
            int n = 0;
            int n2 = 0;
            for (AnnotationGen object22 : list) {
                if (object22.isRuntimeVisible()) {
                    ++n;
                    continue;
                }
                ++n2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream2);
            dataOutputStream.writeShort(n);
            dataOutputStream2.writeShort(n2);
            for (AnnotationGen annotationGen : list) {
                if (annotationGen.isRuntimeVisible()) {
                    annotationGen.dump(dataOutputStream);
                    continue;
                }
                annotationGen.dump(dataOutputStream2);
            }
            dataOutputStream.close();
            dataOutputStream2.close();
            Object object = byteArrayOutputStream.toByteArray();
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            int n3 = -1;
            int n4 = -1;
            if (((Object)object).length > 2) {
                n3 = constantPool.addUtf8("RuntimeVisibleAnnotations");
            }
            if (byArray.length > 2) {
                n4 = constantPool.addUtf8("RuntimeInvisibleAnnotations");
            }
            ArrayList<RuntimeAnnos> arrayList = new ArrayList<RuntimeAnnos>();
            if (((Object)object).length > 2) {
                arrayList.add(new RuntimeVisAnnos(n3, ((Object)object).length, (byte[])object, constantPool));
            }
            if (byArray.length > 2) {
                arrayList.add(new RuntimeInvisAnnos(n4, byArray.length, byArray, constantPool));
            }
            return arrayList;
        }
        catch (IOException iOException) {
            System.err.println("IOException whilst processing annotations");
            iOException.printStackTrace();
            return null;
        }
    }

    public static Attribute[] getParameterAnnotationAttributes(ConstantPool constantPool, List<AnnotationGen>[] listArray) {
        int[] nArray = new int[listArray.length];
        int n = 0;
        int[] nArray2 = new int[listArray.length];
        int n2 = 0;
        try {
            Object object2;
            List<AnnotationGen> list;
            for (int i = 0; i < listArray.length; ++i) {
                list = listArray[i];
                if (list == null) continue;
                for (AnnotationGen object22 : list) {
                    if (object22.isRuntimeVisible()) {
                        int n3 = i;
                        nArray[n3] = nArray[n3] + 1;
                        ++n;
                        continue;
                    }
                    int n4 = i;
                    nArray2[n4] = nArray2[n4] + 1;
                    ++n2;
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            list = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)((Object)list)).writeByte(listArray.length);
            for (int i = 0; i < listArray.length; ++i) {
                ((DataOutputStream)((Object)list)).writeShort(nArray[i]);
                if (nArray[i] <= 0) continue;
                List<AnnotationGen> list2 = listArray[i];
                for (Object object2 : list2) {
                    if (!((AnnotationGen)object2).isRuntimeVisible()) continue;
                    ((AnnotationGen)object2).dump((DataOutputStream)((Object)list));
                }
            }
            ((FilterOutputStream)((Object)list)).close();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream2);
            dataOutputStream.writeByte(listArray.length);
            for (int i = 0; i < listArray.length; ++i) {
                dataOutputStream.writeShort(nArray2[i]);
                if (nArray2[i] <= 0) continue;
                object2 = listArray[i];
                Iterator<AnnotationGen> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    AnnotationGen annotationGen = iterator.next();
                    if (annotationGen.isRuntimeVisible()) continue;
                    annotationGen.dump(dataOutputStream);
                }
            }
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object2 = byteArrayOutputStream2.toByteArray();
            int n5 = -1;
            int n6 = -1;
            if (n > 0) {
                n5 = constantPool.addUtf8("RuntimeVisibleParameterAnnotations");
            }
            if (n2 > 0) {
                n6 = constantPool.addUtf8("RuntimeInvisibleParameterAnnotations");
            }
            ArrayList<RuntimeParamAnnos> arrayList = new ArrayList<RuntimeParamAnnos>();
            if (n > 0) {
                arrayList.add(new RuntimeVisParamAnnos(n5, byArray.length, byArray, constantPool));
            }
            if (n2 > 0) {
                arrayList.add(new RuntimeInvisParamAnnos(n6, ((List<AnnotationGen>)object2).length, (byte[])object2, constantPool));
            }
            return arrayList.toArray(new Attribute[0]);
        }
        catch (IOException iOException) {
            System.err.println("IOException whilst processing parameter annotations");
            iOException.printStackTrace();
            return null;
        }
    }

    public static final byte typeOfSignature(String string) throws ClassFormatException {
        try {
            switch (string.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
            }
            throw new ClassFormatException("Invalid method signature: " + string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
    }

    public static final byte typeOfSignature(char c) throws ClassFormatException {
        switch (c) {
            case 'B': {
                return 8;
            }
            case 'C': {
                return 5;
            }
            case 'D': {
                return 7;
            }
            case 'F': {
                return 6;
            }
            case 'I': {
                return 10;
            }
            case 'J': {
                return 11;
            }
            case 'L': {
                return 14;
            }
            case '[': {
                return 13;
            }
            case 'V': {
                return 12;
            }
            case 'Z': {
                return 4;
            }
            case 'S': {
                return 9;
            }
        }
        throw new ClassFormatException("Invalid type of signature: " + c);
    }

    public static final String codeToString(ByteSequence byteSequence, ConstantPool constantPool, boolean bl) throws IOException {
        int n;
        int n2;
        short s = (short)byteSequence.readUnsignedByte();
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(Constants.OPCODE_NAMES[s]);
        if (s == 170 || s == 171) {
            n2 = byteSequence.getIndex() % 4;
            n4 = n2 == 0 ? 0 : 4 - n2;
            for (n = 0; n < n4; ++n) {
                byte by = byteSequence.readByte();
                if (by == 0) continue;
                System.err.println("Warning: Padding byte != 0 in " + Constants.OPCODE_NAMES[s] + ":" + by);
            }
            n3 = byteSequence.readInt();
        }
        switch (s) {
            case 170: {
                int n5 = byteSequence.readInt();
                int n6 = byteSequence.readInt();
                int n7 = byteSequence.getIndex() - 12 - n4 - 1;
                stringBuffer.append("\tdefault = " + (n3 += n7) + ", low = " + n5 + ", high = " + n6 + "(");
                int[] nArray = new int[n6 - n5 + 1];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = n7 + byteSequence.readInt();
                    stringBuffer.append(nArray[n2]);
                    if (n2 >= nArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                break;
            }
            case 171: {
                int n8 = byteSequence.readInt();
                int n9 = byteSequence.getIndex() - 8 - n4 - 1;
                int[] nArray = new int[n8];
                int[] nArray2 = new int[n8];
                stringBuffer.append("\tdefault = " + (n3 += n9) + ", npairs = " + n8 + " (");
                for (n2 = 0; n2 < n8; ++n2) {
                    nArray[n2] = byteSequence.readInt();
                    nArray2[n2] = n9 + byteSequence.readInt();
                    stringBuffer.append("(" + nArray[n2] + ", " + nArray2[n2] + ")");
                    if (n2 >= n8 - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                stringBuffer.append("\t\t#" + (byteSequence.getIndex() - 1 + byteSequence.readShort()));
                break;
            }
            case 200: 
            case 201: {
                stringBuffer.append("\t\t#" + (byteSequence.getIndex() - 1 + byteSequence.readInt()));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n10;
                if (wide) {
                    n10 = byteSequence.readUnsignedShort();
                    wide = false;
                } else {
                    n10 = byteSequence.readUnsignedByte();
                }
                stringBuffer.append("\t\t%" + n10);
                break;
            }
            case 196: {
                wide = true;
                stringBuffer.append("\t(wide)");
                break;
            }
            case 188: {
                stringBuffer.append("\t\t<" + Constants.TYPE_NAMES[byteSequence.readByte()] + ">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n11 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t" + constantPool.constantToString(n11, (byte)9) + (bl ? " (" + n11 + ")" : ""));
                break;
            }
            case 187: 
            case 192: {
                stringBuffer.append("\t");
            }
            case 193: {
                int n12 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t<" + constantPool.constantToString(n12) + ">" + (bl ? " (" + n12 + ")" : ""));
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                int n13 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t" + constantPool.constantToString(n13) + (bl ? " (" + n13 + ")" : ""));
                break;
            }
            case 185: {
                int n14 = byteSequence.readUnsignedShort();
                n2 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t" + constantPool.constantToString(n14) + (bl ? " (" + n14 + ")\t" : "") + n2 + "\t" + byteSequence.readUnsignedByte());
                break;
            }
            case 186: {
                int n15 = byteSequence.readUnsignedShort();
                byteSequence.readUnsignedShort();
                stringBuffer.append("\t" + constantPool.constantToString(n15) + (bl ? " (" + n15 + ")" : ""));
                break;
            }
            case 19: 
            case 20: {
                int n16 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t" + constantPool.constantToString(n16) + (bl ? " (" + n16 + ")" : ""));
                break;
            }
            case 18: {
                int n17 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t\t" + constantPool.constantToString(n17) + (bl ? " (" + n17 + ")" : ""));
                break;
            }
            case 189: {
                int n18 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t<" + Utility.compactClassName(constantPool.getConstantString(n18, (byte)7), false) + ">" + (bl ? " (" + n18 + ")" : ""));
                break;
            }
            case 197: {
                int n19 = byteSequence.readUnsignedShort();
                n = byteSequence.readUnsignedByte();
                stringBuffer.append("\t<" + Utility.compactClassName(constantPool.getConstantString(n19, (byte)7), false) + ">\t" + n + (bl ? " (" + n19 + ")" : ""));
                break;
            }
            case 132: {
                short s2;
                int n20;
                if (wide) {
                    n20 = byteSequence.readUnsignedShort();
                    s2 = byteSequence.readShort();
                    wide = false;
                } else {
                    n20 = byteSequence.readUnsignedByte();
                    s2 = byteSequence.readByte();
                }
                stringBuffer.append("\t\t%" + n20 + "\t" + s2);
                break;
            }
            default: {
                if (Constants.iLen[s] - 1 <= 0) break;
                block28: for (n = 0; n < Constants.TYPE_OF_OPERANDS[s].length; ++n) {
                    stringBuffer.append("\t\t");
                    switch (Constants.TYPE_OF_OPERANDS[s][n]) {
                        case 8: {
                            stringBuffer.append(byteSequence.readByte());
                            continue block28;
                        }
                        case 9: {
                            stringBuffer.append(byteSequence.readShort());
                            continue block28;
                        }
                        case 10: {
                            stringBuffer.append(byteSequence.readInt());
                            continue block28;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    private static final int pow2(int n) {
        return 1 << n;
    }

    public static String toMethodSignature(Type type, Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = typeArray == null ? 0 : typeArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(typeArray[i].getSignature());
        }
        stringBuffer.append(')');
        stringBuffer.append(type.getSignature());
        return stringBuffer.toString();
    }

    public static class ResultHolder {
        private String result;
        private int consumed;
        public static final ResultHolder BYTE = new ResultHolder("byte", 1);
        public static final ResultHolder CHAR = new ResultHolder("char", 1);
        public static final ResultHolder DOUBLE = new ResultHolder("double", 1);
        public static final ResultHolder FLOAT = new ResultHolder("float", 1);
        public static final ResultHolder INT = new ResultHolder("int", 1);
        public static final ResultHolder LONG = new ResultHolder("long", 1);
        public static final ResultHolder SHORT = new ResultHolder("short", 1);
        public static final ResultHolder BOOLEAN = new ResultHolder("boolean", 1);
        public static final ResultHolder VOID = new ResultHolder("void", 1);

        public ResultHolder(String string, int n) {
            this.result = string;
            this.consumed = n;
        }

        public String getResult() {
            return this.result;
        }

        public int getConsumedChars() {
            return this.consumed;
        }
    }
}

