/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.config;

import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.elasticjob.cloud.ui.config.EventTraceConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.ui.config.RegistryConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.ui.repository.StatisticRdbRepository;
import org.apache.shardingsphere.elasticjob.cloud.ui.web.controller.search.JobEventRdbSearch;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BeanConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BeanConfiguration.class);
    @Autowired
    private EventTraceConfiguration traceConfiguration;
    @Autowired
    private RegistryConfiguration registryConfiguration;

    @Bean
    public CoordinatorRegistryCenter regCenter() {
        ZookeeperRegistryCenter registryCenter = new ZookeeperRegistryCenter(this.registryConfiguration.getZookeeperConfiguration());
        registryCenter.init();
        return registryCenter;
    }

    @Bean
    public StatisticRdbRepository rdbRepository() {
        Optional<TracingConfiguration<DataSource>> tracingConfiguration = this.traceConfiguration.getTracingConfiguration();
        return tracingConfiguration.map(each -> new StatisticRdbRepository((DataSource)each.getTracingStorageConfiguration().getStorage(), true)).orElse(new StatisticRdbRepository(null, false));
    }

    @Bean
    public JobEventRdbSearch jobEventRdbSearch() {
        Optional<TracingConfiguration<DataSource>> tracingConfiguration = this.traceConfiguration.getTracingConfiguration();
        return tracingConfiguration.map(each -> new JobEventRdbSearch((DataSource)each.getTracingStorageConfiguration().getStorage(), true)).orElse(new JobEventRdbSearch(null, false));
    }
}

