/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.LineNumber;

public final class LineNumberTable
extends Attribute {
    private boolean isInPackedState = false;
    private byte[] data;
    private int tableLength;
    private LineNumber[] table;

    public LineNumberTable(LineNumberTable lineNumberTable) {
        this(lineNumberTable.getNameIndex(), lineNumberTable.getLength(), lineNumberTable.getLineNumberTable(), lineNumberTable.getConstantPool());
    }

    public LineNumberTable(int n, int n2, LineNumber[] lineNumberArray, ConstantPool constantPool) {
        super((byte)4, n, n2, constantPool);
        this.setLineNumberTable(lineNumberArray);
        this.isInPackedState = false;
    }

    LineNumberTable(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (LineNumber[])null, constantPool);
        this.data = new byte[n2];
        dataInputStream.readFully(this.data);
        this.isInPackedState = true;
    }

    private void unpack() {
        if (this.isInPackedState) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                this.tableLength = dataInputStream.readUnsignedShort();
                this.table = new LineNumber[this.tableLength];
                for (int i = 0; i < this.tableLength; ++i) {
                    this.table[i] = new LineNumber(dataInputStream);
                }
                dataInputStream.close();
                this.data = null;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unpacking of LineNumberTable attribute failed");
            }
            this.isInPackedState = false;
        }
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        this.unpack();
        classVisitor.visitLineNumberTable(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        if (this.isInPackedState) {
            dataOutputStream.write(this.data);
        } else {
            dataOutputStream.writeShort(this.tableLength);
            for (int i = 0; i < this.tableLength; ++i) {
                this.table[i].dump(dataOutputStream);
            }
        }
    }

    public final LineNumber[] getLineNumberTable() {
        this.unpack();
        return this.table;
    }

    public final void setLineNumberTable(LineNumber[] lineNumberArray) {
        this.data = null;
        this.isInPackedState = false;
        this.table = lineNumberArray;
        this.tableLength = lineNumberArray == null ? 0 : lineNumberArray.length;
    }

    @Override
    public final String toString() {
        this.unpack();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < this.tableLength; ++i) {
            stringBuffer2.append(this.table[i].toString());
            if (i < this.tableLength - 1) {
                stringBuffer2.append(", ");
            }
            if (stringBuffer2.length() <= 72) continue;
            stringBuffer2.append('\n');
            stringBuffer.append(stringBuffer2);
            stringBuffer2.setLength(0);
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    public int getSourceLine(int n) {
        this.unpack();
        int n2 = 0;
        int n3 = this.tableLength - 1;
        if (n3 < 0) {
            return -1;
        }
        int n4 = -1;
        int n5 = -1;
        do {
            int n6;
            int n7;
            if ((n7 = this.table[n6 = (n2 + n3) / 2].getStartPC()) == n) {
                return this.table[n6].getLineNumber();
            }
            if (n < n7) {
                n3 = n6 - 1;
            } else {
                n2 = n6 + 1;
            }
            if (n7 >= n || n7 <= n5) continue;
            n5 = n7;
            n4 = n6;
        } while (n2 <= n3);
        if (n4 < 0) {
            return -1;
        }
        return this.table[n4].getLineNumber();
    }

    public final int getTableLength() {
        this.unpack();
        return this.tableLength;
    }
}

