/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.guarantee;

import java.util.Collection;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.guarantee.GuaranteeNode;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class GuaranteeService {
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;

    public GuaranteeService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
    }

    public void registerStart(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            this.jobNodeStorage.createJobNodeIfNeeded(GuaranteeNode.getStartedNode(each));
        }
    }

    public boolean isRegisterStartSuccess(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            if (this.jobNodeStorage.isJobNodeExisted(GuaranteeNode.getStartedNode(each))) continue;
            return false;
        }
        return true;
    }

    public boolean isAllStarted() {
        return this.jobNodeStorage.isJobNodeExisted("guarantee/started") && this.configService.load(false).getShardingTotalCount() == this.jobNodeStorage.getJobNodeChildrenKeys("guarantee/started").size();
    }

    public void clearAllStartedInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("guarantee/started");
    }

    public void registerComplete(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            this.jobNodeStorage.createJobNodeIfNeeded(GuaranteeNode.getCompletedNode(each));
        }
    }

    public boolean isRegisterCompleteSuccess(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            if (this.jobNodeStorage.isJobNodeExisted(GuaranteeNode.getCompletedNode(each))) continue;
            return false;
        }
        return true;
    }

    public boolean isAllCompleted() {
        return this.jobNodeStorage.isJobNodeExisted("guarantee/completed") && this.configService.load(false).getShardingTotalCount() <= this.jobNodeStorage.getJobNodeChildrenKeys("guarantee/completed").size();
    }

    public void clearAllCompletedInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("guarantee/completed");
    }
}

