/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import org.apache.shenyu.admin.model.entity.DashboardUserDO;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.user.BatchUserDeletedEvent;
import org.apache.shenyu.admin.model.event.user.UserCreatedEvent;
import org.apache.shenyu.admin.model.event.user.UserUpdatedEvent;
import org.apache.shenyu.admin.service.publish.AdminDataModelChangedEventPublisher;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class UserEventPublisher
implements AdminDataModelChangedEventPublisher<DashboardUserDO> {
    private final ApplicationEventPublisher publisher;

    public UserEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void onCreated(DashboardUserDO data) {
        this.publish(new UserCreatedEvent(data, SessionUtil.visitorName()));
    }

    @Override
    public void onUpdated(DashboardUserDO data, DashboardUserDO before) {
        this.publish(new UserUpdatedEvent(data, before, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(Collection<DashboardUserDO> users) {
        this.publish(new BatchUserDeletedEvent(users, SessionUtil.visitorName()));
    }

    @Override
    public void publish(AdminDataModelChangedEvent event) {
        this.publisher.publishEvent((ApplicationEvent)event);
    }
}

