/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.support;

import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.convert.DtoInstantiatingConverter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.ldap.repository.support.LdapEntityInformation;
import org.springframework.data.ldap.repository.support.QuerydslLdapQuery;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.querydsl.ListQuerydslPredicateExecutor;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.util.Assert;

public class QuerydslLdapPredicateExecutor<T>
implements ListQuerydslPredicateExecutor<T> {
    private final EntityInformation<T, ?> entityInformation;
    private final ProjectionFactory projectionFactory;
    private final LdapOperations ldapOperations;
    private final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext;
    private final EntityInstantiators entityInstantiators = new EntityInstantiators();

    public QuerydslLdapPredicateExecutor(Class<T> entityType, ProjectionFactory projectionFactory, LdapOperations ldapOperations, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        Assert.notNull(entityType, (String)"Entity type must not be null");
        Assert.notNull((Object)projectionFactory, (String)"ProjectionFactory must not be null");
        Assert.notNull((Object)ldapOperations, (String)"LdapOperations must not be null");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        this.entityInformation = new LdapEntityInformation<T>(entityType, ldapOperations.getObjectDirectoryMapper());
        this.ldapOperations = ldapOperations;
        this.projectionFactory = projectionFactory;
        this.mappingContext = mappingContext;
    }

    public QuerydslLdapPredicateExecutor(EntityInformation<T, ?> entityInformation, ProjectionFactory projectionFactory, LdapOperations ldapOperations, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        Assert.notNull(entityInformation, (String)"EntityInformation must not be null");
        Assert.notNull((Object)projectionFactory, (String)"ProjectionFactory must not be null");
        Assert.notNull((Object)ldapOperations, (String)"LdapOperations must not be null");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        this.entityInformation = entityInformation;
        this.ldapOperations = ldapOperations;
        this.projectionFactory = projectionFactory;
        this.mappingContext = mappingContext;
    }

    public Optional<T> findOne(Predicate predicate) {
        return ((FluentQuery.FetchableFluentQuery)this.findBy(predicate, Function.identity())).one();
    }

    public List<T> findAll(Predicate predicate) {
        return this.queryFor(predicate).list();
    }

    public long count(Predicate predicate) {
        return this.findBy(predicate, FluentQuery.FetchableFluentQuery::count);
    }

    public boolean exists(Predicate predicate) {
        return this.findBy(predicate, FluentQuery.FetchableFluentQuery::exists);
    }

    public List<T> findAll(Predicate predicate, Sort sort) {
        Assert.notNull((Object)sort, (String)"Pageable must not be null");
        if (sort.isUnsorted()) {
            return this.findAll(predicate);
        }
        throw new UnsupportedOperationException("Sorting is not supported");
    }

    public List<T> findAll(OrderSpecifier<?> ... orders) {
        if (orders.length == 0) {
            return this.findAll(new OrderSpecifier[0]);
        }
        throw new UnsupportedOperationException("Sorting is not supported");
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        if (orders.length == 0) {
            return this.findAll(predicate);
        }
        throw new UnsupportedOperationException("Sorting is not supported");
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        if (pageable.isUnpaged()) {
            return PageableExecutionUtils.getPage((List)this.findAll(predicate), (Pageable)pageable, () -> this.count(predicate));
        }
        if (pageable.getSort().isUnsorted() && pageable.getPageNumber() == 0) {
            return PageableExecutionUtils.getPage(this.queryFor(predicate, q -> q.countLimit(pageable.getPageSize())).list(), (Pageable)pageable, () -> this.count(predicate));
        }
        throw new UnsupportedOperationException("Pagination and Sorting is not supported");
    }

    public <S extends T, R> R findBy(Predicate predicate, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        return queryFunction.apply(new FluentQuerydsl(predicate, this.entityInformation.getJavaType()));
    }

    private QuerydslLdapQuery<T> queryFor(Predicate predicate) {
        return this.queryFor(predicate, it -> {});
    }

    private QuerydslLdapQuery<T> queryFor(Predicate predicate, Consumer<LdapQueryBuilder> queryBuilderConsumer) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return new QuerydslLdapQuery(this.ldapOperations, this.entityInformation.getJavaType(), queryBuilderConsumer).where(new Predicate[]{predicate});
    }

    class FluentQuerydsl<R>
    implements FluentQuery.FetchableFluentQuery<R> {
        private final Predicate predicate;
        private final Sort sort;
        private final Class<R> resultType;
        private final List<String> projection;

        FluentQuerydsl(Predicate predicate, Class<R> resultType) {
            this(predicate, Sort.unsorted(), resultType, Collections.emptyList());
        }

        FluentQuerydsl(Predicate predicate, Sort sort, Class<R> resultType, List<String> projection) {
            this.predicate = predicate;
            this.sort = sort;
            this.resultType = resultType;
            this.projection = projection;
        }

        public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
            throw new UnsupportedOperationException();
        }

        public <R1> FluentQuery.FetchableFluentQuery<R1> as(Class<R1> resultType) {
            Assert.notNull(this.projection, (String)"Projection target type must not be null");
            return new FluentQuerydsl<R1>(this.predicate, this.sort, resultType, this.projection);
        }

        public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
            Assert.notNull(properties, (String)"Projection properties must not be null");
            return new FluentQuerydsl<R>(this.predicate, this.sort, this.resultType, new ArrayList<String>(properties));
        }

        @Nullable
        public R oneValue() {
            List results = this.findTop(2);
            if (results.isEmpty()) {
                return null;
            }
            if (results.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(1);
            }
            Object one = results.get(0);
            return this.getConversionFunction().apply(one);
        }

        @Nullable
        public R firstValue() {
            List results = this.findTop(2);
            if (results.isEmpty()) {
                return null;
            }
            Object one = results.get(0);
            return this.getConversionFunction().apply(one);
        }

        public List<R> all() {
            return this.stream().collect(Collectors.toList());
        }

        public Page<R> page(Pageable pageable) {
            Assert.notNull((Object)pageable, (String)"Pageable must not be null");
            if (pageable.isUnpaged()) {
                return PageableExecutionUtils.getPage(this.all(), (Pageable)pageable, this::count);
            }
            if (pageable.getSort().isUnsorted() && pageable.getPageNumber() == 0) {
                Function<Object, R> conversionFunction = this.getConversionFunction();
                return PageableExecutionUtils.getPage(this.findTop(pageable.getPageSize()).stream().map(conversionFunction).collect(Collectors.toList()), (Pageable)pageable, this::count);
            }
            throw new UnsupportedOperationException("Pagination and Sorting is not supported");
        }

        public Stream<R> stream() {
            Function<Object, R> conversionFunction = this.getConversionFunction();
            return this.search(null, QuerydslLdapQuery::list).stream().map(conversionFunction);
        }

        public long count() {
            return this.search(null, q -> q.search(it -> true)).size();
        }

        public boolean exists() {
            return !this.search(1, q -> q.search(it -> true)).isEmpty();
        }

        private List<T> findTop(int limit) {
            return this.search(limit, QuerydslLdapQuery::list);
        }

        private <S> S search(@Nullable Integer limit, Function<QuerydslLdapQuery<T>, S> searchFunction) {
            QuerydslLdapQuery q = QuerydslLdapPredicateExecutor.this.queryFor(this.predicate, query -> {
                List<String> projection = this.getProjection();
                if (!projection.isEmpty()) {
                    query.attributes(projection.toArray(new String[0]));
                }
                if (limit != null) {
                    query.countLimit(limit.intValue());
                }
            });
            return searchFunction.apply(q);
        }

        private <P> Function<Object, P> getConversionFunction(Class<?> inputType, Class<P> targetType) {
            if (targetType.isAssignableFrom(inputType)) {
                return Function.identity();
            }
            if (targetType.isInterface()) {
                return o -> QuerydslLdapPredicateExecutor.this.projectionFactory.createProjection(targetType, o);
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(targetType, QuerydslLdapPredicateExecutor.this.mappingContext, QuerydslLdapPredicateExecutor.this.entityInstantiators);
            return o -> converter.convert(o);
        }

        private Function<Object, R> getConversionFunction() {
            return this.getConversionFunction(QuerydslLdapPredicateExecutor.this.entityInformation.getJavaType(), this.resultType);
        }

        private List<String> getProjection() {
            if (this.projection.isEmpty()) {
                ProjectionInformation projectionInformation;
                if (this.resultType.isAssignableFrom(QuerydslLdapPredicateExecutor.this.entityInformation.getJavaType())) {
                    return this.projection;
                }
                if (this.resultType.isInterface() && (projectionInformation = QuerydslLdapPredicateExecutor.this.projectionFactory.getProjectionInformation(this.resultType)).isClosed()) {
                    return projectionInformation.getInputProperties().stream().map(FeatureDescriptor::getName).collect(Collectors.toList());
                }
            }
            return this.projection;
        }
    }
}

